/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.moneta.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.moneta.common.bean.Transaction;
import ru.bitel.bgbilling.modules.moneta.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.moneta.server.bean.Constants;
import ru.bitel.bgbilling.modules.moneta.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Moneta")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("moneta");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.setResultParam("gateUrl", this.moduleSetup.get("moneta.gate.url", "https://www.moneta.ru/assistant.htm"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    public void cancel() throws BGException {
        this.execute();
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        this.setResultParam("gateUrl", this.moduleSetup.get("moneta.gate.url", "https://www.moneta.ru/assistant.htm"));
        this.setResultParam("formFields", new String[]{"MNT_ID", "MNT_AMOUNT", "MNT_TRANSACTION_ID", "MNT_CURRENCY_CODE", "MNT_TEST_MODE", "MNT_DESCRIPTION", "MNT_SUBSCRIBER_ID", "MNT_SIGNATURE"});
        this.setResultParam("MNT_ID", this.moduleSetup.get("moneta.mnt.id", ""));
        this.setResultParam("MNT_AMOUNT", this.sum.toPlainString().replace(',', '.'));
        this.setResultParam("MNT_CURRENCY_CODE", this.moduleSetup.get("moneta.mnt.currency.code", "RUB"));
        this.setResultParam("MNT_SUBSCRIBER_ID", String.valueOf(this.contractId));
        this.setResultParam("MNT_TEST_MODE", this.moduleSetup.get("moneta.mnt.test.mode", "0"));
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.doSign(this.contractId, this.sum, false, this.moduleSetup.get("moneta.sign.check.code", ""), this.getResult());
        }
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        String description = this.moduleSetup.get("moneta.mnt.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()).replace("{CONTRACT_COMMENT}", contract.getComment());
        this.setResultParam("MNT_DESCRIPTION", description);
        this.context.getResponse().setHeader("Pragma", "no-cache");
        this.context.getResponse().setHeader("Cache-Control", "no-cache");
    }
}

