/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelPeriodNavigation;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.mps.client.ActionServiceConfig;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.service.MPSService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class TransactionReviseMonitor
extends ServiceConfigTabbedPanel {
    private boolean init = false;
    private String mode = "1";
    private String currentMPS = null;
    private BGButton process = new BGButton();
    private JLabel resultLabel = new JLabel();
    private ModeRadioButton modeRadioButton = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private BGControlPanelPeriodNavigation periodPanel = new BGControlPanelPeriodNavigation();
    private BGComboBox<ComboBoxItem> systemListComboBox = new BGComboBox();
    private BGSelectFilePanel selectFilePanel = new BGSelectFilePanel(false);
    private List<Transaction> exTransactionList = new ArrayList<Transaction>();
    private List<Transaction> dbTransactionList = new ArrayList<Transaction>();
    private List<Transaction> canTransactionList = new ArrayList<Transaction>();
    private List<Transaction> disTransactionList = new ArrayList<Transaction>();
    private TransactionTableModel resultTransactionTableModel = new TransactionTableModel("resultTransactionReviseMonitor");
    private BGUTable resultTable = new BGUTable((TableModel)((Object)this.resultTransactionTableModel));

    public TransactionReviseMonitor() {
        this.rb_name = ClientUtils.getRBName(ActionServiceConfig.class);
        this.getModuleDoc(ActionServiceConfig.class);
        try {
            this.initialize();
            this.resultTable.setSelectionMode(2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initialize() {
        final JPopupMenu exMenu = new JPopupMenu();
        final JPopupMenu dbMenu = new JPopupMenu();
        final JPopupMenu canMenu = new JPopupMenu();
        ActionListener itemActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if ("1".equals(TransactionReviseMonitor.this.mode)) {
                    TransactionReviseMonitor.this.process(TransactionReviseMonitor.this.resultTransactionTableModel, "add");
                } else if ("2".equals(TransactionReviseMonitor.this.mode)) {
                    TransactionReviseMonitor.this.process(TransactionReviseMonitor.this.resultTransactionTableModel, "cancel");
                } else if ("3".equals(TransactionReviseMonitor.this.mode)) {
                    TransactionReviseMonitor.this.process(TransactionReviseMonitor.this.resultTransactionTableModel, "restore");
                }
            }
        };
        exMenu.add(new ResultMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", itemActionListener));
        dbMenu.add(new ResultMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", itemActionListener));
        canMenu.add(new ResultMenuItem("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c", itemActionListener));
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    if ("1".equals(TransactionReviseMonitor.this.mode)) {
                        exMenu.show((Component)TransactionReviseMonitor.this.resultTable, event.getX(), event.getY());
                    } else if ("2".equals(TransactionReviseMonitor.this.mode)) {
                        dbMenu.show((Component)TransactionReviseMonitor.this.resultTable, event.getX(), event.getY());
                    } else if ("3".equals(TransactionReviseMonitor.this.mode)) {
                        canMenu.show((Component)TransactionReviseMonitor.this.resultTable, event.getX(), event.getY());
                    }
                }
            }
        });
        BGTitleBorder titleBorder = new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434");
        this.periodPanel.add(Box.createHorizontalStrut(5));
        this.periodPanel.setBorder((Border)titleBorder);
        this.process.setText("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c");
        this.process.setActionCommand("process");
        this.process.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransactionReviseMonitor.this.actionMapper(e);
            }
        });
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new GridBagLayout());
        toppanel.setBorder((Border)new BGTitleBorder(" \u0424\u0430\u0439\u043b "));
        toppanel.add((Component)this.selectFilePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        toppanel.add((Component)this.systemListComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        toppanel.add((Component)this.process, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        ActionListener buttonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                List<Transaction> transactionList = null;
                String actionCommand = event.getActionCommand();
                if ("1".equals(actionCommand)) {
                    transactionList = TransactionReviseMonitor.this.exTransactionList;
                } else if ("2".equals(actionCommand)) {
                    transactionList = TransactionReviseMonitor.this.dbTransactionList;
                } else if ("3".equals(actionCommand)) {
                    transactionList = TransactionReviseMonitor.this.canTransactionList;
                } else if ("4".equals(actionCommand)) {
                    transactionList = TransactionReviseMonitor.this.disTransactionList;
                }
                if (transactionList != null) {
                    TransactionReviseMonitor.this.mode = actionCommand;
                    TransactionReviseMonitor.this.resultTransactionTableModel.setData(transactionList);
                    TransactionReviseMonitor.this.setResultLabelData(transactionList.size());
                }
            }
        };
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.modeRadioButton = new ModeRadioButton("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", "1", buttonActionListener, this.buttonGroup, true);
        buttonPanel.add((Component)this.modeRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        buttonPanel.add((Component)new ModeRadioButton("\u041b\u0438\u0448\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", "2", buttonActionListener, this.buttonGroup, false), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        buttonPanel.add((Component)new ModeRadioButton("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0435, \u043d\u043e \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0432\u0443\u044e\u0449\u0438\u0435 \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435", "3", buttonActionListener, this.buttonGroup, false), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        buttonPanel.add((Component)new ModeRadioButton("\u041e\u0442\u043b\u0438\u0447\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0438", "4", buttonActionListener, this.buttonGroup, false), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        buttonPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.resultLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 15), 0, 0));
        JPanel resultPanel = new JPanel(new GridBagLayout());
        resultPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 "));
        resultPanel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        resultPanel.add((Component)new JScrollPane((Component)this.resultTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        rightPanel.add((Component)toppanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 0), 0, 0));
        rightPanel.add((Component)resultPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(rightPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void actionMapper(String action) {
        if (action.equals("process")) {
            this.processFile();
        }
    }

    private void actionMapper(ActionEvent event) {
        this.actionMapper(event.getActionCommand());
    }

    private void processFile() {
        File file = this.selectFilePanel.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        String fileString = null;
        try {
            fileString = new String(Utils.readByBlock((InputStream)new FileInputStream(file)), "UTF-8");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435: UTF-8; " + ex.getMessage()));
            ex.printStackTrace();
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("RevisePayments");
        request.setModuleId(this.getModuleId());
        ComboBoxItem item = (ComboBoxItem)this.systemListComboBox.getSelectedItem();
        if (item != null) {
            this.currentMPS = String.valueOf(item.getObject());
            request.setAttribute("system", this.currentMPS);
        }
        request.setAttribute("file", fileString);
        request.setAttribute("fileName", file.getName());
        request.setAttribute("from", this.periodPanel.getDateString1());
        request.setAttribute("until", this.periodPanel.getDateString2());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.exTransactionList = this.getTransactionList(XMLUtils.selectElements((Node)doc, (String)"//sup_table/data/row"));
            this.dbTransactionList = this.getTransactionList(XMLUtils.selectElements((Node)doc, (String)"//mis_table/data/row"));
            this.canTransactionList = this.getTransactionList(XMLUtils.selectElements((Node)doc, (String)"//can_table/data/row"));
            this.disTransactionList = this.getTransactionList(XMLUtils.selectElements((Node)doc, (String)"//dis_table/data/row"));
            this.mode = "1";
            this.modeRadioButton.setSelected(true);
            this.resultTransactionTableModel.setData(this.exTransactionList);
            this.setResultLabelData(this.exTransactionList.size());
        }
    }

    private void setResultLabelData(int count) {
        this.resultLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439: " + count);
    }

    private List<Transaction> getTransactionList(Iterable<Element> iterable) {
        ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
        for (Element element : iterable) {
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(Utils.parseInt((String)element.getAttribute("id")))).setContractId(Utils.parseInt((String)element.getAttribute("cid")))).setTransId(element.getAttribute("trans")).setSum(new BigDecimal(element.getAttribute("summ")))).setPaymentId(Utils.parseInt((String)element.getAttribute("pid")))).setTime(TimeUtils.parseDate((String)element.getAttribute("date"), (String)"dd.MM.yyyy HH:mm:ss")).setContractTitle(element.getAttribute("contract"))).setStatus(element.getAttribute("status"))).setRawNumber(element.getAttribute("rawNumber")).setType(Utils.parseInt((String)element.getAttribute("type"))).build();
            transactionList.add(transaction);
        }
        return transactionList;
    }

    public void setData() {
        if (!this.init) {
            String selectedId = this.systemListComboBox.getSelectedId();
            this.systemListComboBox.removeAllItems();
            try {
                KeyValue keyValue;
                List data = ((MPSService)this.getContext().getPort(MPSService.class)).getMPSSystemList();
                data.forEach(a -> this.systemListComboBox.addItem((Object)new ComboBoxItem((Object)a.getKey(), a.getValue())));
                if (selectedId != null && (keyValue = (KeyValue)data.stream().filter(a -> a.getKey().equals(selectedId)).findFirst().orElse(null)) != null) {
                    this.systemListComboBox.setSelectedItem((Object)keyValue);
                }
            }
            catch (BGException data) {
                // empty catch block
            }
            this.init = true;
            GregorianCalendar yesterday = new GregorianCalendar();
            ((Calendar)yesterday).add(5, -1);
            this.periodPanel.setDateFrom(yesterday.getTime());
            this.periodPanel.setDateTo(yesterday.getTime());
        }
    }

    private void process(TransactionTableModel tableModel, String param) {
        List rows = tableModel.getSelectedRows();
        if (rows.size() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
        } else {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            Document doc = null;
            try {
                DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                doc = docBuilder.newDocument();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            Element payments = doc.createElement("payments");
            doc.appendChild(payments);
            for (Transaction transaction : rows) {
                Element payment = doc.createElement("payment");
                payments.appendChild(payment);
                payment.setAttribute("trans_id", transaction.getTransId());
                payment.setAttribute("cid", String.valueOf(transaction.getContractId()));
                payment.setAttribute("summ", transaction.getSum().toPlainString());
                payment.setAttribute("time", TimeUtils.format((Date)transaction.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
                payment.setAttribute("pid", String.valueOf(transaction.getPaymentId()));
            }
            try {
                String result = XMLUtils.serializeToString((Node)doc, (boolean)false);
                Request request = new Request();
                request.setModule(this.module);
                request.setModuleId(this.getModuleId());
                request.setAction("RevisePayments");
                request.setAttribute("payments", result);
                request.setAttribute("param", param);
                request.setAttribute("system", this.currentMPS);
                if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                    this.processFile();
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    class ModeRadioButton
    extends JToggleButton {
        public ModeRadioButton(String text, String actionCommand, ActionListener actionListener, ButtonGroup buttonGroup, boolean selected) {
            super(text, selected);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
            buttonGroup.add(this);
        }
    }

    class TransactionTableModel
    extends AbstractTransactionTableModel<Transaction> {
        public TransactionTableModel(String name) {
            super(name, Transaction.class);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("#\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u041f\u0421", 150, 200, 250, "transId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0412\u0440\u0435\u043c\u044f (\u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441 \u041f\u0421)", -1, -1, -1, "time", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", -1, -1, -1, "rawNumber", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumnContractTitle();
            this.addColumnSum();
        }
    }

    class ResultMenuItem
    extends JMenuItem {
        public ResultMenuItem(String text, ActionListener actionListener) {
            super(text);
            this.addActionListener(actionListener);
        }
    }
}

