/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public final class CPTransactionManager
extends MPSTransactionManager {
    private static final Pattern summPattern = Pattern.compile("[0-9\\.]*");
    private static final String TIMEPATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(.+)\\t(\\d+)\\t([\\d+: -T]+)\\t(\\d+\\.*\\d*)\\t(\\d+)$", 8);

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("encoding", (Object)this.getEncoding());
        mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            mpsResponse.getParameters().put("request", mpsRequest);
            switch (mpsRequest.getAction()) {
                case 1: {
                    contract = this.actionCheck(mpsRequest);
                    mpsResponse.setContract(contract);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    break;
                }
                case 2: 
                case 10: {
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null) ** GOTO lbl28
                    contract = this.actionCheck(mpsRequest);
                    this.checkTime(mpsRequest);
                    mpsResponse.setContract(contract);
                    transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    ** GOTO lbl38
lbl28:
                    // 1 sources

                    contractManager = new ContractManager(con);
                    try {
                        contract = contractManager.getContractById(transaction.getContractId());
                    }
                    finally {
                        contractManager.close();
                    }
                    if (contract != null) {
                        mpsResponse.setContract(contract);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    }
lbl38:
                    // 4 sources

                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    break;
                }
                case 4: {
                    now = new GregorianCalendar();
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        mpsResponse.setResult(9);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        break;
                    }
                    now.add(12, -10);
                    if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode()) && now.after(transaction.getLocalTime())) {
                        mpsResponse.setResult(9);
                        mpsResponse.setMessage("\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435. \u0412\u0440\u0435\u043c\u044f \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432\u044b\u0448\u043b\u043e");
                        break;
                    }
                    this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    break;
                }
                case 3: {
                    now = new GregorianCalendar();
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        now.set(5, 1);
                        now.add(2, -1);
                        transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    }
                    if (transaction == null) {
                        mpsResponse.setResult(6);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        break;
                    }
                    if (!transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(7);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    } else {
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element responseElement = XMLUtils.createElement((Document)doc, (String)"response");
        this.processResponseEvent(response, responseElement);
        XMLUtils.createElement((Element)responseElement, (String)"code").setTextContent(String.valueOf(response.getResult()));
        if (response.getAction() > 0 && response.getAction() != 1 && response.getAction() != 10 && (response.getResult() == 0 || response.getResult() == 7)) {
            XMLUtils.createElement((Element)responseElement, (String)"authcode").setTextContent(String.valueOf(response.getId()));
            XMLUtils.createElement((Element)responseElement, (String)"date").setTextContent(TimeUtils.format((Date)response.getLocalTime(), (String)TIMEPATTERN));
        }
        if (response.getMessage() != null) {
            XMLUtils.createElement((Element)responseElement, (String)"message").setTextContent(response.getMessage());
        }
        this.setResponseParameters(response, responseElement);
        return this.xmlSerialize(doc);
    }

    @Override
    public String getDefaultEncoding() {
        return "cp1251";
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter("action");
        if ("check".equals(actionString)) {
            mpsRequest.setAction(1);
        } else if ("payment".equals(actionString)) {
            mpsRequest.setAction(2);
        } else if ("status".equals(actionString)) {
            mpsRequest.setAction(3);
        } else if ("cancel".equals(actionString)) {
            mpsRequest.setAction(4);
        }
        String summString = request.getParameter("amount");
        mpsRequest.setNumber(request.getParameter("number"));
        mpsRequest.setRawNumber(mpsRequest.getNumber());
        mpsRequest.setType(Utils.parseInt((String)request.getParameter("type"), (int)-1));
        mpsRequest.setSum(Utils.parseBigDecimal((String)summString, (BigDecimal)BigDecimal.ZERO));
        mpsRequest.setTransId(request.getParameter("receipt"));
        mpsRequest.setTime(TimeUtils.parseDate((String)request.getParameter("date"), (String)TIMEPATTERN));
        switch (mpsRequest.getAction()) {
            case 2: {
                if (summString != null && summPattern.matcher(summString).matches()) break;
                throw new MPSException(8, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            }
        }
        return mpsRequest;
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        BigInteger transId = this.parseBigInteger(req.getTransId());
        switch (req.getAction()) {
            case 1: {
                if (req.getNumber() == null || req.getNumber().length() <= 0) {
                    throw new MPSException(2);
                }
                if (req.getType() < 0 && system.searchTypes.length > 1 || req.getType() >= system.searchTypes.length) {
                    throw new MPSException(12, "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0438\u0441\u043a\u0430");
                }
                if (req.getSum() != null && (system.extDontCheckSum || req.getSum().compareTo(BigDecimal.ZERO) > 0)) break;
                throw new MPSException(8, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            }
            case 2: {
                if (req.getTransId() == null || transId == null || transId.compareTo(BigInteger.ZERO) <= 0) {
                    throw new MPSException(15, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u0442\u043d\u043e\u0435/\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438)");
                }
                if (req.getTime() == null) {
                    throw new MPSException(16);
                }
                if (req.getNumber() == null || req.getNumber().length() <= 0) {
                    throw new MPSException(2);
                }
                if (req.getType() < 0 && system.searchTypes.length > 1 || req.getType() >= system.searchTypes.length) {
                    throw new MPSException(12, "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0438\u0441\u043a\u0430");
                }
                if (req.getSum() != null && (system.extDontCheckSum || req.getSum().compareTo(BigDecimal.ZERO) > 0)) break;
                throw new MPSException(8, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
            }
            case 3: 
            case 4: {
                if (req.getTransId() != null && transId != null && transId.compareTo(BigInteger.ZERO) > 0) break;
                throw new MPSException(15, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u0442\u043d\u043e\u0435/\u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (ID \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438)");
            }
        }
        super.checkValid(system, req, con);
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(1);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(2);
                response.setMessage(ex.message);
                break;
            }
            case 5: {
                response.setResult(6);
                response.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                break;
            }
            case 6: {
                response.setResult(5);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(3);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(10);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(10);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(10);
                response.setMessage(ex.message);
                break;
            }
            case 12: {
                response.setResult(-2);
                response.setMessage(ex.message);
                break;
            }
            case 15: {
                response.setResult(4);
                response.setMessage(ex.message);
                break;
            }
            case 16: {
                response.setResult(5);
                response.setMessage(ex.message);
                break;
            }
            case 20: {
                response.setResult(11);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = TRANSACTION_PATTERN.matcher(file);
        while (match.find()) {
            String number = match.group(1);
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setNumber(number).setRawNumber(number).setTime(TimeUtils.parseDate((String)match.group(3), (String)TIMEPATTERN)).setSum(Utils.parseBigDecimal((String)match.group(4), (BigDecimal)BigDecimal.ZERO))).setTransId(Utils.parseLong((String)match.group(5), (long)0L)).setStatus(TransactionStatus.PAYMENT_PAYED.getCode())).build();
            result.add(transaction);
        }
        return result;
    }

    private class ErrorCode {
        protected static final int ANSWER_ERR_TYPE = -2;
        protected static final int ANSWER_ERR_ADDITIONPARAM = -1;
        protected static final int ANSWER_SUCCESS = 0;
        protected static final int ANSWER_ERR_REQUEST = 1;
        protected static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 2;
        protected static final int ANSWER_ERR_PAYMENT_AMOUNT = 3;
        protected static final int ANSWER_ERR_TRANSACTION_ID = 4;
        protected static final int ANSWER_ERR_DATE = 5;
        protected static final int ANSWER_ERR_PAYMENT = 6;
        protected static final int ANSWER_ERR_PAYMENT_CANCELED = 7;
        protected static final int ANSWER_ERR_PAYMENT_DONT_KNOWN = 8;
        protected static final int ANSWER_ERR_PAYMENT_CANT_CANCEL = 9;
        protected static final int ANSWER_ERR_UNKNOWN = 10;

        private ErrorCode() {
        }
    }
}

