/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CitiPayTransactionManager
extends MPSTransactionManager {
    private static final String TIMEPATTERN = "yyyyMMddHHmmss";
    private static final String REQUEST_PARAM_AMOUNT = "Amount";
    private static final String REQUEST_PARAM_ACCOUNT = "Account";
    private static final String REQUEST_PARAM_QUERY_TYPE = "QueryType";
    private static final String REQUEST_PARAM_TRANSACTION_ID = "TransactionId";
    private static final String REQUEST_PARAM_TRANSACTION_DATE = "TransactionDate";
    private static final String RESPONSE_AMOUNT = "Amount";
    private static final String RESPONSE_COMMENT = "Comment";
    private static final String RESPONSE_RESULT_CODE = "ResultCode";
    private static final String RESPONSE_TRANSACTION_ID = "TransactionId";
    private static final String RESPONSE_TRANSACTION_EXT = "TransactionExt";
    private static final String QUERY_TYPE_PAY = "pay";
    private static final String QUERY_TYPE_CHECK = "check";
    private static final String QUERY_TYPE_CANCEL = "cancel";
    private DecimalFormat df = null;

    public CitiPayTransactionManager() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.df = new DecimalFormat("########0.00", dfs);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest httpRequest, HttpServletResponse response) {
        mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            request = this.parseRequest(con, moduleId, mpsId, system, httpRequest);
            mpsResponse.setAction(request.getAction());
            mpsResponse.setTransId(request.getTransId());
            mpsResponse.setTime(request.getTime());
            mpsResponse.setNumber(request.getNumber());
            mpsResponse.getParameters().clear();
            mpsResponse.getParameters().putAll(request.parameters);
            mpsResponse.setSum(request.getSum());
            this.checkValid(system, request, con);
            switch (request.getAction()) {
                case 1: {
                    currencyTitle = Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.");
                    if (request.getSum().compareTo(system.minSumm) < 0) {
                        throw new MPSException(22, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + system.minSumm + " " + currencyTitle + ", \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + system.maxSumm + " " + currencyTitle);
                    }
                    if (request.getSum().compareTo(system.maxSumm) > 0) {
                        throw new MPSException(23, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + system.minSumm + " " + currencyTitle + ", \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + system.maxSumm + " " + currencyTitle);
                    }
                    mpsResponse.setSum(request.getSum());
                    contract = this.actionCheck(request);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    break;
                }
                case 2: {
                    transaction = this.getTransactionByTransId(con, moduleId, mpsId, request.getTransId(), request.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(299);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        break;
                    }
                    if (transaction != null) ** GOTO lbl38
                    contract = this.actionCheck(request);
                    this.checkTime(request);
                    transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), request.getTime(), request.getSum(), request.getTransId(), request.getRawNumber(), request.getType(), system.title);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    ** GOTO lbl49
lbl38:
                    // 1 sources

                    mpsResponse.setResult(299);
                    mpsResponse.setTime(transaction.getTime());
                    contractManager = new ContractManager(con);
                    try {
                        contract = contractManager.getContractById(transaction.getContractId());
                    }
                    finally {
                        contractManager.close();
                    }
                    if (contract != null) {
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    }
lbl49:
                    // 4 sources

                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        String queryType = request.getParameter(REQUEST_PARAM_QUERY_TYPE);
        if (QUERY_TYPE_CHECK.equals(queryType)) {
            mpsRequest.setAction(1);
        } else if (QUERY_TYPE_PAY.equals(queryType)) {
            mpsRequest.setAction(2);
        } else if (QUERY_TYPE_CANCEL.equals(queryType)) {
            mpsRequest.setAction(4);
        }
        mpsRequest.setRawNumber(request.getParameter(REQUEST_PARAM_ACCOUNT));
        mpsRequest.setNumber(mpsRequest.getRawNumber());
        mpsRequest.setType(0);
        mpsRequest.setSum(Utils.parseBigDecimal((String)request.getParameter("Amount"), (BigDecimal)BigDecimal.ZERO));
        mpsRequest.setTransId(request.getParameter("TransactionId"));
        mpsRequest.setTime(TimeUtils.parseDate((String)request.getParameter(REQUEST_PARAM_TRANSACTION_DATE), (String)TIMEPATTERN));
        return mpsRequest;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(299);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(21);
                response.setMessage(ex.message);
                break;
            }
            case 22: {
                response.setResult(241);
                response.setMessage(ex.message);
                break;
            }
            case 23: {
                response.setResult(242);
                response.setMessage(ex.message);
                break;
            }
            case -1: {
                response.setResult(2);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(23);
                response.setMessage(ex.message);
                break;
            }
            default: {
                response.setResult(299);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element rootNode = doc.createElement("Response");
        doc.appendChild(rootNode);
        if (response.getTransId() != null) {
            XMLUtils.createElement((Element)rootNode, (String)"TransactionId").setTextContent(response.getTransId());
        }
        if ((response.getAction() == 2 || response.getAction() == 4) && response.getId() != 0L) {
            XMLUtils.createElement((Element)rootNode, (String)RESPONSE_TRANSACTION_EXT).setTextContent(String.valueOf(response.getId()));
        }
        XMLUtils.createElement((Element)rootNode, (String)"Amount").setTextContent(this.df.format(response.getSum()));
        XMLUtils.createElement((Element)rootNode, (String)RESPONSE_RESULT_CODE).setTextContent(String.valueOf(response.getResult()));
        XMLUtils.createElement((Element)rootNode, (String)RESPONSE_COMMENT).setTextContent(response.getMessage());
        return this.xmlSerialize(doc);
    }

    private static class ErrorCode {
        protected static final int CODE_0 = 0;
        protected static final int CODE_2 = 2;
        protected static final int CODE_21 = 21;
        protected static final int CODE_23 = 23;
        protected static final int CODE_241 = 241;
        protected static final int CODE_242 = 242;
        protected static final int CODE_299 = 299;

        private ErrorCode() {
        }
    }
}

