/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.client;

import bitel.billing.module.common.ActionPerformer;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.model.Period;

public class CalendarTreePanel
extends JPanel
implements ActionPerformer {
    private JTree tree;
    private ModTreeNode rootNode;
    private transient Vector<ActionListener> actionListeners;

    public CalendarTreePanel() {
    }

    public CalendarTreePanel(int fromYear, int toYear) {
        this.setYears(fromYear, toYear);
    }

    public void setYears(int fromYear, int toYear) {
        this.rootNode = new ModTreeNode();
        this.rootNode.setAttribute("id", (Object)"0");
        this.rootNode.setText("\u0413\u043e\u0434\u044b");
        this.rootNode.setIcon("note");
        GregorianCalendar date = new GregorianCalendar();
        date.set(fromYear, 0, 1, 0, 0, 0);
        this.rootNode.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(toYear, 11, 31, 23, 59, 59);
        this.rootNode.setAttribute("date_to", (Object)date);
        this.tree = new JTree((TreeNode)this.rootNode);
        try {
            this.buildTree(fromYear, toYear);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(" \u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c "));
        this.add((Component)new JScrollPane(this.tree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "");
                CalendarTreePanel.this.fireActionPerformed(ae);
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
    }

    public void buildTree(int from, int to) {
        for (int i = from; i <= to; ++i) {
            ModTreeNode newYear = new ModTreeNode(String.valueOf(i), "calend1");
            GregorianCalendar date = new GregorianCalendar();
            date.set(i, 0, 1, 0, 0, 0);
            newYear.setAttribute("date_from", (Object)date);
            date = new GregorianCalendar();
            date.set(i, 11, 31, 23, 59, 59);
            newYear.setAttribute("date_to", (Object)date);
            newYear.setAttribute("id", (Object)String.valueOf(i));
            this.rootNode.add((MutableTreeNode)newYear);
            this.addMonthsNodes(newYear);
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        ClientUtils.expandTree((JTree)this.tree, (DefaultMutableTreeNode)this.rootNode);
    }

    private void addMonthsNodes(ModTreeNode node) {
        int year = ((GregorianCalendar)node.getAttribute("date_from")).get(1);
        ModTreeNode newMonth = new ModTreeNode("\u042f\u043d\u0432\u0430\u0440\u044c", "clock1");
        GregorianCalendar date = new GregorianCalendar();
        date.set(year, 0, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 0, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("01" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0424\u0435\u0432\u0440\u0430\u043b\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 1, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 1, 28, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("02" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u041c\u0430\u0440\u0442", "clock1");
        date = new GregorianCalendar();
        date.set(year, 2, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 2, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("03" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0410\u043f\u0440\u0435\u043b\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 3, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 3, 30, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("04" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u041c\u0430\u0439", "clock1");
        date = new GregorianCalendar();
        date.set(year, 4, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 4, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("05" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0418\u044e\u043d\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 5, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 5, 30, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("06" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0418\u044e\u043b\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 6, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 6, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("07" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0410\u0432\u0433\u0443\u0441\u0442", "clock1");
        date = new GregorianCalendar();
        date.set(year, 7, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 7, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("08" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 8, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 8, 30, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("09" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u041e\u043a\u0442\u044f\u0431\u0440\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 9, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 9, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("10" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u041d\u043e\u044f\u0431\u0440\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 10, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 10, 30, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("11" + year));
        node.add((MutableTreeNode)newMonth);
        newMonth = new ModTreeNode("\u0414\u0435\u043a\u0430\u0431\u0440\u044c", "clock1");
        date = new GregorianCalendar();
        date.set(year, 11, 1, 0, 0, 0);
        newMonth.setAttribute("date_from", (Object)date);
        date = new GregorianCalendar();
        date.set(year, 11, 31, 23, 59, 59);
        newMonth.setAttribute("date_to", (Object)date);
        newMonth.setAttribute("id", (Object)("12" + year));
        node.add((MutableTreeNode)newMonth);
    }

    public void selectNodeByDate(Calendar date) {
        String id = String.valueOf(date.get(2)) + date.get(1);
        this.selectNodeByDate(this.rootNode, id);
    }

    private void selectNodeByDate(ModTreeNode node, String id) {
        if (node != null) {
            if (id.equals(node.getAttribute("id"))) {
                node.setSel(true);
                return;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.selectNodeByDate((ModTreeNode)node.getChildAt(i), id);
            }
        }
    }

    public Period getSelectedPeriod() {
        Period period = new Period();
        try {
            Object date_from = ((ModTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getAttribute("date_from");
            Object date_to = ((ModTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getAttribute("date_to");
            period.setDateFrom(((GregorianCalendar)date_from).getTime());
            period.setDateTo(((GregorianCalendar)date_to).getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return period;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector<ActionListener> v = new Vector<ActionListener>(this.actionListeners);
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector<ActionListener> v = new Vector<ActionListener>();
        if (this.actionListeners != null) {
            v.addAll(this.actionListeners);
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            Vector<ActionListener> listeners = this.actionListeners;
            for (int i = 0; i < listeners.size(); ++i) {
                listeners.elementAt(i).actionPerformed(actionEvent);
            }
        }
    }
}

