/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client;

import bitel.billing.module.services.ServiceConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.bgbilling.modules.reports.client.constructor.GenerateReportOptions;
import ru.bitel.bgbilling.modules.reports.client.constructor.ReportConstructorPanel;
import ru.bitel.bgbilling.modules.reports.client.modules.Report;
import ru.bitel.bgbilling.modules.reports.client.modules.kernel.ReportParams_Default;
import ru.bitel.bgbilling.modules.reports.common.dto.ReportModule;
import ru.bitel.bgbilling.modules.reports.common.service.ReportService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class AllModuleReportsComboBox
extends BGUPanel {
    private Report report = null;
    private JButton reportButton = new JButton("\u041e\u0442\u0447\u0435\u0442 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
    private List<ReportModule> moduleItems = new ArrayList<ReportModule>();
    private BGButton infoButton = new BGButton();
    private Map<String, Element> reportXmlMap = new HashMap<String, Element>();
    private BGButton openConstructor;
    private Consumer<Report> doReport;

    protected AllModuleReportsComboBox() {
        this(null);
    }

    protected AllModuleReportsComboBox(Consumer<Report> doReport) {
        this.doReport = doReport;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getReportSelectPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
    }

    private JPanel getReportSelectPanel() {
        JMenuItem menuItem = new JMenuItem("\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043a\u044d\u0448");
        menuItem.addActionListener(e -> {
            try {
                ((ReportService)((ClientContext)this.getContext()).getWebService(ReportService.class)).resetReportCache();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(menuItem);
        this.reportButton.setComponentPopupMenu(popupMenu);
        this.reportButton.addActionListener(e -> new ReportSelectDialog("\u0412\u044b\u0431\u043e\u0440 \u043e\u0442\u0447\u0435\u0442\u0430", "").open());
        this.openConstructor = new BGButton();
        this.openConstructor.setIcon((Icon)ClientUtils.getIcon((String)"silk/cog.png"));
        this.openConstructor.setEnabled(false);
        this.openConstructor.setToolTipText("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0432 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432");
        this.openConstructor.addActionListener(e -> {
            ServiceConfig serviceConfig = (ServiceConfig)BGClientBase.getFrame().getTabbedPane().getTab("module_config_" + ((ClientContext)this.getContext()).getModuleId());
            ReportConstructorPanel reportConstructorPanel = (ReportConstructorPanel)serviceConfig.getTab(ReportConstructorPanel.class.getName());
            GenerateReportOptions generateReportOptions = this.buildGeneratedReportOption();
            if (reportConstructorPanel != null && generateReportOptions != null) {
                reportConstructorPanel.setReport(generateReportOptions);
                serviceConfig.selectTab(ReportConstructorPanel.class.getName());
            }
        });
        this.infoButton.setIcon((Icon)ClientUtils.getIcon((String)"help.png"));
        this.infoButton.setEnabled(false);
        this.infoButton.setToolTipText("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0442\u0447\u0435\u0442\u0435");
        this.infoButton.addActionListener(e -> this.showDoc());
        this.infoButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ClientUtils.showErrorMessageDialog((Throwable)new BGException(AllModuleReportsComboBox.this.getReport().getInfo()));
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u041e\u0442\u0447\u0435\u0442"));
        panel.add((Component)this.reportButton, new GridBagConstraints(0, -1, 1, 2, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.infoButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        panel.add((Component)this.openConstructor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        return panel;
    }

    public void setData() {
        try {
            this.moduleItems = ((ReportService)((ClientContext)this.getContext()).getWebService(ReportService.class)).reportModules();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private GenerateReportOptions buildGeneratedReportOption() {
        Element reportXml = this.reportXmlMap.get(this.report.item.getAttribute("title"));
        if (reportXml == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u043d\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0432 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0435. \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c xml \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0442\u0440\u0443 \u043e\u0442\u0447\u0435\u0442\u0430.");
            return null;
        }
        String processingClass = reportXml.getAttribute("report_class");
        if (Utils.isBlankString((String)processingClass)) {
            processingClass = reportXml.getAttribute("dyn_class");
        }
        String title = reportXml.getAttribute("title");
        String reportXmlFileName = this.report.id + ".rep.xml";
        GenerateReportOptions.XmlReportParser xmlReportParser = GenerateReportOptions.xmlParser(reportXml);
        return GenerateReportOptions.builder().setReportTitle(title).setReportFileName(reportXmlFileName).setProcessingClass(processingClass).setFilters(xmlReportParser.parseFilters()).setFields(xmlReportParser.parseFields()).setNeedScroll(xmlReportParser.parseScrollSetting()).build();
    }

    public Report getReport() {
        return this.report;
    }

    private void showDoc() {
        if (this.report != null) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(this.report.reportDocUrl));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
        }
    }

    class ReportSelectDialog
    extends BGEditorDialog<String> {
        private BGUList<ReportModule> moduleList;
        private BGUList<KeyValue> reportList;

        public ReportSelectDialog(String title, String data) {
            super(title, (Object)data);
            this.moduleList = new BGUList();
            this.reportList = new BGUList();
        }

        public void doDialogPanel() {
            this.moduleList.setSelectionMode(0);
            this.moduleList.setCellRenderer((ListCellRenderer)new ModuleListCellRenderer());
            this.moduleList.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    ArrayList list = new ArrayList();
                    if (!"separator".equals(((ReportModule)this.moduleList.getSelectedValue()).getType())) {
                        try {
                            list.addAll(((ReportService)((ClientContext)AllModuleReportsComboBox.this.getContext()).getWebService(ReportService.class)).getModuleReportList(((ReportModule)this.moduleList.getSelectedValue()).getModule()));
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                    this.reportList.setData(list);
                }
            });
            this.reportList.setSelectionMode(0);
            this.reportList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        ((JButton)ReportSelectDialog.this.optionPane.getOptions()[0]).doClick();
                    }
                }
            });
            this.panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u0442\u0447\u0435\u0442:"), new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.moduleList, (int)300, (int)300), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.reportList, (int)500, (int)300), new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(2, 10, 0, 0), 0, 0));
            this.moduleList.setData(AllModuleReportsComboBox.this.moduleItems);
        }

        public boolean doApply() throws Exception {
            ReportModule reportModule = (ReportModule)this.moduleList.getSelectedValue();
            if (reportModule == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044c");
                return false;
            }
            KeyValue selectedReport = (KeyValue)this.reportList.getSelectedValue();
            if (selectedReport == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0442\u0447\u0435\u0442");
                return false;
            }
            AllModuleReportsComboBox.this.infoButton.setEnabled(false);
            try {
                String reportItem = ((ReportService)((ClientContext)AllModuleReportsComboBox.this.getContext()).getWebService(ReportService.class)).getReportData(reportModule.getModule(), selectedReport.getKey());
                Document document = XMLUtils.parseDocument((String)new String(Base64.getDecoder().decode(reportItem), "UTF-8"));
                AllModuleReportsComboBox.this.report = new Report(document.getDocumentElement());
                AllModuleReportsComboBox.this.report.moduleId = reportModule.getModuleId();
                NodeList childs = document.getDocumentElement().getChildNodes();
                for (int j = 0; j < childs.getLength(); ++j) {
                    Node n = childs.item(j);
                    if (!"report".equals(n.getNodeName())) continue;
                    Element reportXml = (Element)n;
                    reportXml.setAttribute("id", AllModuleReportsComboBox.this.report.id);
                    reportXml.setAttribute("params_class", AllModuleReportsComboBox.this.report.paramsClass);
                    reportXml.setAttribute("report_class", AllModuleReportsComboBox.this.report.reportClass);
                    AllModuleReportsComboBox.this.reportXmlMap.put(AllModuleReportsComboBox.this.report.item.getAttribute("title"), reportXml);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                AllModuleReportsComboBox.this.report = null;
            }
            if (AllModuleReportsComboBox.this.report != null) {
                AllModuleReportsComboBox.this.openConstructor.setEnabled(ReportParams_Default.class.getName().equals(AllModuleReportsComboBox.this.report.paramsClass) && "java".equals(AllModuleReportsComboBox.this.report.type));
                if (AllModuleReportsComboBox.this.report.reportParams == null && Utils.notBlankString((String)AllModuleReportsComboBox.this.report.paramsClass)) {
                    try {
                        ReportParams reportParams = (ReportParams)((Object)Class.forName(AllModuleReportsComboBox.this.report.paramsClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        reportParams.init(((ClientContext)AllModuleReportsComboBox.this.getContext()).getModule(), ((ClientContext)AllModuleReportsComboBox.this.getContext()).getModuleId());
                        reportParams.setReportMid(AllModuleReportsComboBox.this.report.moduleId);
                        reportParams.setReportInfo(AllModuleReportsComboBox.this.report.item);
                        reportParams.setData();
                        AllModuleReportsComboBox.this.report.reportParams = reportParams;
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                AllModuleReportsComboBox.this.infoButton.setEnabled(Utils.notEmptyString((String)AllModuleReportsComboBox.this.report.reportDocUrl));
                AllModuleReportsComboBox.this.infoButton.setToolTipText(AllModuleReportsComboBox.this.report.getInfo());
                AllModuleReportsComboBox.this.doReport.accept(AllModuleReportsComboBox.this.report);
                AllModuleReportsComboBox.this.reportButton.setText("<html><p style='font-size: 90%;'>" + ((ReportModule)this.moduleList.getSelectedValue()).getGuiTitle() + ":</p><p style='font-size: 120%;'>" + AllModuleReportsComboBox.this.report.getGuiTitle() + "</p></html>");
            }
            return super.doApply();
        }
    }

    class ModuleListCellRenderer
    extends DefaultListCellRenderer {
        private Font separatorFont = this.getFont().deriveFont(this.getFont().getSize2D() * 1.2f);

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            boolean separator = "separator".equals(((ReportModule)value).getType());
            if (separator) {
                label.setFont(this.separatorFont);
                label.setBackground(Color.LIGHT_GRAY);
            }
            label.setHorizontalAlignment(separator ? 0 : 2);
            label.setText(((ReportModule)value).getGuiTitle());
            return label;
        }
    }
}

