/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.action;

import bitel.billing.server.ActionBase;
import bitel.billing.server.ActionConType;
import jakarta.mail.MessagingException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.io.output.TeeOutputStream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportUtils;
import ru.bitel.bgbilling.modules.reports.server.mail.MailReport;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

@ActionConType(value=2)
public class ActionReport
extends ActionBase {
    public void doAction() throws SQLException, BGException, IOException {
        String id = this.getParameter("report_id");
        BGReport report = null;
        try {
            log.debug("Generate report with id=" + id);
            report = BGReportUtils.getReport(id, this.con, this.conSlave, this.moduleSetup, this.userId, log);
            BGReportUtils.addRequestParams(report, this.request);
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430 \"" + id + "\"", (Throwable)ex);
        }
        if (report != null) {
            HttpServletResponse response = this.getResponse();
            String maildest = this.getParameter("maildest");
            ByteArrayOutputStream baos = null;
            if (Utils.notBlankString((String)maildest)) {
                baos = new ByteArrayOutputStream(50000);
            }
            try {
                response.setContentType(report.getContentType());
                ServletOutputStream out = response.getOutputStream();
                if (baos != null) {
                    out = new TeeOutputStream((OutputStream)out, (OutputStream)baos);
                }
                report.fillReportToStream((OutputStream)out);
                out.flush();
                out.close();
                if (baos != null) {
                    this.sendMail(report, maildest, baos);
                }
            }
            catch (BGMessageException ex) {
                response.setContentType("error");
                ServletOutputStream out = response.getOutputStream();
                PrintWriter ps = new PrintWriter((OutputStream)out, true, StandardCharsets.UTF_8);
                ps.write("\u041e\u0448\u0438\u0431\u043a\u0430! " + ex.getMessage());
                ps.close();
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                response.setContentType("error");
                ServletOutputStream out = response.getOutputStream();
                PrintWriter ps = new PrintWriter((OutputStream)out, true, StandardCharsets.UTF_8);
                ex.printStackTrace(ps);
                out.flush();
                out.close();
                log.error("error fill report id=" + id + " to stream", (Throwable)ex);
            }
        }
    }

    private void sendMail(BGReport report, String maildest, ByteArrayOutputStream baos) throws BGException, MessagingException {
        StringBuilder message = new StringBuilder(666);
        message.append("\u041e\u0442\u0447\u0451\u0442: ").append(report.getId()).append("\n\n\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b:\n");
        for (Map.Entry<String, String> params : report.getParams().entrySet()) {
            String paramName = params.getKey();
            if (paramName.equals("id") || paramName.equals("mid")) continue;
            message.append(paramName).append(": ").append(params.getValue()).append("\n");
        }
        message.append("\n\u0424\u043e\u0440\u043c\u0430\u0442: ").append(report.getContentType());
        message.append("\n\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430: ").append(baos.size());
        String fileExt = report.getContentType();
        String fileContentType = "application/octet-stream";
        switch (report.getContentType()) {
            case "csv": {
                fileContentType = "text/csv";
            }
        }
        try {
            MailReport mailData = new MailReport();
            mailData.setModuleId(this.mid);
            mailData.setRecipients(maildest);
            mailData.setSubject("\u041e\u0442\u0447\u0451\u0442");
            mailData.addTextPart("text", message.toString());
            mailData.addPart("file", "attachment", fileContentType, "report." + report.getId() + "." + fileExt, baos.toByteArray());
            new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }
}

