/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopDirectoryItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopItemType;
import ru.bitel.bgbilling.plugins.shop.common.bean.ShopProductTreeItem;
import ru.bitel.bgbilling.plugins.shop.common.service.ShopService;
import ru.bitel.bgbilling.plugins.shop.server.dao.ShopDirectoryItemDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.ShopItemDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.ShopProductItemDao;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.shop.common.service.ShopService")
public class ShopServiceImpl
extends AbstractService
implements ShopService {
    public List<ShopItemType> shopItemTypeList() throws BGException, BGMessageException {
        try (ShopItemDao shopItemDao = new ShopItemDao(this.getConnection());){
            List<ShopItemType> list = shopItemDao.list();
            return list;
        }
    }

    public List<ShopItemType> shopItemTypeListByIds(List<Integer> itemTypeIds) throws BGException, BGMessageException {
        try (ShopItemDao shopItemDao = new ShopItemDao(this.getConnection());){
            List<ShopItemType> list = shopItemDao.list(itemTypeIds);
            return list;
        }
    }

    public int shopItemTypeUpdate(ShopItemType shopItemType) throws BGException, BGMessageException {
        try (ShopItemDao shopItemDao = new ShopItemDao(this.getConnection());){
            shopItemDao.update(shopItemType);
            int n = shopItemType.getId();
            return n;
        }
    }

    public List<ShopDirectoryItem> shopDirectoryItemList() throws BGException, BGMessageException {
        try (ShopDirectoryItemDao shopDirectoryItemDao = new ShopDirectoryItemDao(this.getConnection());){
            List<ShopDirectoryItem> list = shopDirectoryItemDao.list();
            return list;
        }
    }

    public int shopDirectoryItemUpdate(ShopDirectoryItem shopDirectoryItem) throws BGException, BGMessageException {
        try (ShopDirectoryItemDao shopDirectoryItemDao = new ShopDirectoryItemDao(this.getConnection());){
            shopDirectoryItemDao.update(shopDirectoryItem);
            int n = shopDirectoryItem.getId();
            return n;
        }
    }

    public List<ShopProductTreeItem> shopProductTreeItemList() throws BGException, BGMessageException {
        ArrayList<ShopProductTreeItem> items = new ArrayList<ShopProductTreeItem>();
        try (ShopDirectoryItemDao shopDirectoryItemDao = new ShopDirectoryItemDao(this.getConnection());
             ShopProductItemDao shopProductItemDao = new ShopProductItemDao(this.getConnection());){
            items.addAll(shopDirectoryItemDao.list().stream().map(ShopDirectoryItem::toShopProductTreeItem).toList());
        }
        return items;
    }
}

