/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.task;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.task.SormUploadTaskCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRUpload;

public class CDRUploadTask
extends SormUploadTaskCommon {
    private static final Logger log = LogManager.getLogger();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        log.info("\u0417\u0430\u043f\u0443\u0441\u043a \u0437\u0430\u0434\u0430\u0447\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 CDR");
        List<SormProject> activeSormProjects = this.getActiveSormProjects();
        for (SormProject sormProject : activeSormProjects) {
            try {
                log.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430: " + sormProject.getTitle());
                CDRUpload uploadImplementation = this.defineCDRUploadImplementation(sormProject);
                if (uploadImplementation == null) {
                    log.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 CDR!");
                    break;
                }
                log.info("\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 = " + uploadImplementation.getClass().getName());
                uploadImplementation.uploadCDR();
            }
            catch (BGException e) {
                log.error((Object)e);
            }
        }
    }

    private CDRUpload defineCDRUploadImplementation(SormProject sormProject) throws BGException {
        SormManufacturer sormManufacturer = SormManufacturer.getType((int)sormProject.getLoadedConfig().getInt("sorm.manufacturer", -1));
        if (sormManufacturer == null) {
            return null;
        }
        ServerContext serverContext = (ServerContext)ServerContext.get();
        for (DynamicClass dynamicClass : ((DynamicCodeService)serverContext.getService(DynamicCodeService.class, 0)).getDynamicClassesByInterface(CDRUpload.class.getName())) {
            CDRUpload cdrUploadImplementation = (CDRUpload)DynamicClassManager.getInstance().newInstance(CDRUpload.class, dynamicClass.getClassName(), new Class[]{Integer.TYPE, SormProject.class}, new Object[]{this.moduleId, sormProject});
            if (cdrUploadImplementation == null || !sormManufacturer.equals((Object)cdrUploadImplementation.getSormManufacturer())) continue;
            return cdrUploadImplementation;
        }
        return null;
    }

    public String getDescription() {
        return "\u0421\u041e\u0420\u041c. \u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 CDR";
    }
}

