/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans;

import java.util.stream.Stream;

public enum NorsiTransFileTitle {
    INET_ABONENTS("inetAbonents", "/abonents/abonents"),
    PHONE_ABONENTS("phoneAbonents", "/abonents/abonents-pstn"),
    INET_PAYMENT("inetPayment", "/payments/balance-fillup"),
    PHONE_PAYMENT("phonePayment", "/payments/balance-fillup-pstn"),
    DOC_TYPE("docType", "/dictionaries/doc-types"),
    PAYMENT_TYPE("paymentType", "/dictionaries/pay-types"),
    IP_NUMBERING("ipNumberingPlan", "/dictionaries/ip-numbering-plan"),
    SWITCHES("switches", "/dictionaries/switches"),
    GATEWAYS("ipGate", "/dictionaries/gates"),
    PHONE_NUMBERING("phoneNumbering", "/dictionaries/telephone_numbering_plans"),
    CAUSE_CODES("causeCodes", "/dictionaries/term-causes"),
    BUNCHES("bunches", "/dictionaries/bunches"),
    SUPPLEMENTARY_SERVICES("supplementServices", "/dictionaries/supplement-services"),
    DEPARTAMENT("telcos", "/dictionaries/telcos/"),
    CDR("cdr", "/cdr/atc");

    private final String title;
    private final String ftpDirectory;

    private NorsiTransFileTitle(String title, String ftpDirectory) {
        this.title = title;
        this.ftpDirectory = ftpDirectory;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFTPDirectory() {
        return this.ftpDirectory;
    }

    public static String getFTPDirectory(String fileTitle) {
        return Stream.of(NorsiTransFileTitle.values()).filter(a -> a.getTitle().equals(fileTitle)).findFirst().map(NorsiTransFileTitle::getFTPDirectory).orElse("/");
    }
}

