/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.JSONSerializationUtils;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.Directional;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class SormBunchesPanel
extends BGPanel {
    private BGDialogToolBar toolBar;
    private JPanel editorPanel;
    private final JPanel additionallyPanel = new JPanel(new GridBagLayout());
    private final JTextField bunchId = new JTextField(5);
    private final JTextField title = new JTextField();
    private final JTextField description = new JTextField();
    private final BGUComboBox<Directional> directional = new BGUComboBox();
    private final JTextField mac = new JTextField();
    private final JTextField idCommutator = new JTextField();
    private final BGControlPanelPeriod period = new BGControlPanelPeriod();
    private BGUTable bunchesTable;
    private BGTableModel<Bunch> tableModel;
    private final List<Bunch> bunchList = new ArrayList<Bunch>();
    private Bunch currentBunch;

    SormBunchesPanel() {
        this.setLayout(new GridBagLayout());
        this.init();
    }

    private void init() {
        this.initToolBar();
        this.initTable();
        this.editorPanel = this.getEditorPanel();
        this.description.setDocument(new LengthRestrictedDocument(256));
        Dimension dimension = new Dimension(650, 200);
        JScrollPane tableScroll = new JScrollPane((Component)this.bunchesTable);
        tableScroll.setPreferredSize(dimension);
        tableScroll.setMaximumSize(dimension);
        this.bunchesTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    SormBunchesPanel.this.editRow();
                }
            }
        });
        this.add(this.editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(tableScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
    }

    private void initToolBar() {
        this.toolBar = new BGDialogToolBar();
        this.toolBar.setDefaultButtons(e -> {
            switch (e.getActionCommand()) {
                case "newItem": {
                    this.addRow();
                    break;
                }
                case "editItem": {
                    this.editRow();
                    break;
                }
                case "deleteItem": {
                    this.deleteRow();
                }
            }
        });
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(0);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
    }

    private void addRow() {
        this.currentBunch = null;
        this.bunchId.setText("");
        this.title.setText("");
        this.description.setText("");
        this.mac.setText("");
        this.idCommutator.setText("");
        this.period.setDateFrom(null);
        this.period.setDateTo(null);
        this.directional.setSelectedIndex(0);
        this.showEditorPanel(true);
    }

    private void editRow() {
        this.currentBunch = (Bunch)this.tableModel.getSelectedRow();
        if (this.currentBunch != null) {
            this.bunchesTable.setEnabled(false);
            this.bunchId.setText(String.valueOf(this.currentBunch.getId()));
            this.title.setText(this.currentBunch.getTitle());
            this.mac.setText(this.currentBunch.getMac());
            this.idCommutator.setText(this.currentBunch.getIdCommutator());
            this.period.setDateFrom(this.currentBunch.getDateStart());
            this.period.setDateTo(this.currentBunch.getDateEnd());
            this.description.setText(this.currentBunch.getDescription());
            this.directional.setSelectedItem((Object)this.currentBunch.getDirectional());
            this.showEditorPanel(true);
        }
    }

    private void deleteRow() {
        Bunch bunch = (Bunch)this.tableModel.getSelectedRow();
        if (bunch != null) {
            int deletedId = bunch.getId();
            this.bunchList.remove(bunch);
            this.bunchList.forEach(b -> {
                if (b.getId() > deletedId) {
                    b.setId(b.getId() - 1);
                }
            });
            this.tableModel.setData(this.bunchList);
        }
    }

    private void initTable() {
        this.tableModel = new BGTableModel<Bunch>("bunches"){

            protected void initColumns() {
                this.addColumn("ID", Integer.class, -1, 50, -1, "id", false);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, 200, -1, "title", false);
                this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u044c", String.class, -1, 200, -1, "directional", false);
                this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", String.class, -1, 200, -1, "description", false);
            }

            public Object getValue(Bunch val, int column) throws BGException {
                if (column == 2) {
                    switch (val.getDirectional()) {
                        case INBOUND: {
                            return Directional.INBOUND.getGuiTitle();
                        }
                        case OUTBOUND: {
                            return Directional.OUTBOUND.getGuiTitle();
                        }
                        case BIDIRECTIONAL: {
                            return Directional.BIDIRECTIONAL.getGuiTitle();
                        }
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.bunchesTable = new BGUTable(this.tableModel);
    }

    private JPanel getEditorPanel() {
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.setVisible(false);
        BGButtonPanelOkCancel buttonPanel = new BGButtonPanelOkCancel();
        BGSwingUtilites.wrapBorder((JPanel)this.additionallyPanel, (String)"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        this.additionallyPanel.add((Component)BGSwingUtilites.createHelpLabel((String)"\u041f\u0435\u0440\u0438\u043e\u0434 \u0438 MAC-\u0430\u0434\u0440\u0435\u0441 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043d\u0435 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u0432 \u0421\u041e\u0420\u041c.", (int)-1), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.additionallyPanel.add((Component)new JLabel("MAC-\u0430\u0434\u0440\u0435\u0441"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.additionallyPanel.add((Component)this.mac, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.additionallyPanel.add((Component)new JLabel("ID \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u0430"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.additionallyPanel.add((Component)this.idCommutator, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.additionallyPanel.add((Component)this.period, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel mainTrunkInfo = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)mainTrunkInfo, (String)"\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435");
        this.directional.setData(Arrays.asList(Directional.values()));
        mainTrunkInfo.add((Component)new JLabel("ID \u043f\u0443\u0447\u043a\u0430"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
        mainTrunkInfo.add((Component)this.bunchId, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
        mainTrunkInfo.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        mainTrunkInfo.add((Component)this.title, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
        mainTrunkInfo.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u044c"), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
        mainTrunkInfo.add((Component)this.directional, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 3), 0, 0));
        mainTrunkInfo.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        mainTrunkInfo.add((Component)this.description, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
        editorPanel.add((Component)mainTrunkInfo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        editorPanel.add((Component)this.additionallyPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        editorPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.getButtonOk().addActionListener(e -> {
            String id = this.bunchId.getText();
            if (Utils.isBlankString((String)id) || !id.matches("[0-9]+")) {
                BGToolTip.showErrorMessage((JComponent)this.bunchId, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c ID");
                return;
            }
            String name = this.title.getText();
            if (Utils.isBlankString((String)name)) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return;
            }
            if (this.currentBunch == null) {
                this.currentBunch = new Bunch();
                this.bunchList.add(this.currentBunch);
            }
            this.currentBunch.setId(Integer.parseInt(id));
            this.currentBunch.setTitle(this.title.getText());
            this.currentBunch.setMac(this.mac.getText());
            this.currentBunch.setIdCommutator(this.idCommutator.getText());
            this.currentBunch.setDateStart(this.period.getDateFrom());
            this.currentBunch.setDateEnd(this.period.getDateTo());
            this.currentBunch.setDirectional((Directional)this.directional.getSelectedItem());
            this.currentBunch.setDescription(this.description.getText());
            this.tableModel.setData(this.bunchList);
            this.showEditorPanel(false);
        });
        buttonPanel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> this.showEditorPanel(false));
        return editorPanel;
    }

    private void showEditorPanel(boolean show) {
        this.toolBar.setVisible(!show);
        this.editorPanel.setVisible(show);
        this.bunchesTable.setEnabled(!show);
    }

    void saveBunches(Preferences config) {
        if (Utils.notEmptyCollection(this.bunchList)) {
            config.set("sorm.upload.bunches", JSONSerializationUtils.serializateListToString(this.bunchList));
        }
    }

    void loadBunches(Preferences config) {
        String bunchesJson = config.get("sorm.upload.bunches");
        if (Utils.notBlankString((String)bunchesJson)) {
            this.bunchList.addAll(JSONSerializationUtils.convertJsonToList((String)bunchesJson, Bunch.class));
        }
        this.tableModel.setData(this.bunchList);
    }

    public List<Bunch> getBunchList() {
        return this.bunchList;
    }

    final class LengthRestrictedDocument
    extends PlainDocument {
        private final int limit;

        LengthRestrictedDocument(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offs, str, a);
            } else {
                BGToolTip.showErrorMessage((JComponent)SormBunchesPanel.this.description, (String)"\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f 256 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            }
        }
    }
}

