package ru.bitel.bgbilling.modules.sorm.dyn.cdr;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRUploadCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.specialtehnology.SpecTehConstants;
import ru.bitel.bgbilling.modules.sorm.server.upload.specialtehnology.SpecTehFileTitles;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.common.Utils;

import java.nio.file.Path;
import java.util.List;

import static ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils.getUploadFile;

public class SpecTehCDRUpload
    extends CDRUploadCommon
{
    private final List<Bunch> bunches;

    public SpecTehCDRUpload( int sormModuleId,
                             SormProject sormProject )
        throws BGException
    {
        super( sormModuleId, sormProject );
        this.bunches = SormUtils.getBunches( config );
    }

    @Override
    public SormManufacturer getSormManufacturer()
    {
        return SormManufacturer.SPECIALTECHNOLOGY;
    }

    @Override
    protected Path getFile()
        throws BGException
    {
        return getUploadFile( localUserPath,
                              SpecTehFileTitles.CDR.getTitle(),
                              SpecTehConstants.FILE_NAME_DATE_PATTERN );
    }

    @Override
    protected String[] getHeader()
    {
        return new String[]{ "TYPE", "BEGIN_TIME", "DURATION", "CALL_TYPE_ID", "SUPP_SVC_ID", "IN_ABN_TYPE" ,
                             "OUT_ABN_TYPE", "TERM_CAUSE", "SWITCH_ID", "IN_BUNCH", "IN_BUNCH_MAC", "IN_BUNCH_VPI",
                             "IN_BUNCH_VCI", "OUT_BUNCH", "OUT_BUNCH_MAC", "OUT_BUNCH_VPI", "OUT_BUNCH_VCI", "IN_INFO_ID",
                             "IN_INFO_DIR_NUMBER", "IN_INFO_INT_NUMBER", "IN_INFO_IMSI", "IN_INFO_IMEI", "IN_INFO_MIN", "IN_INFO_ICC",
                             "IN_INFO_MAC", "IN_INFO_VPI", "IN_INFO_VCI", "IN_INFO_USER", "IN_INFO_IP_ADDR", "IN_INFO_EMAIL",
                             "IN_INFO_PIN", "IN_INFO_DOMAIN", "IN_INFO_RESERVE", "IN_INFO_IP_MASK", "IN_INFO_ORIG_NAME", "OUT_INFO_ID",
                             "OUT_INFO_DIR_NUMBER", "OUT_INFO_INT_NUMBER", "OUT_INFO_IMSI", "OUT_INFO_IMEI", "OUT_INFO_MIN", "OUT_INFO_ICC",
                             "OUT_INFO_MAC", "OUT_INFO_VPI", "OUT_INFO_VCI", "OUT_INFO_USER", "OUT_INFO_IP_ADDR", "OUT_INFO_EMAIL",
                             "OUT_INFO_PIN", "OUT_INFO_DOMAIN", "OUT_INFO_RESERVE", "OUT_INFO_IP_MASK", "OUT_INFO_ORIG_NAME", "IN_BEGIN_LOC_TYPE",
                             "IN_BEGIN_LOC_LAC", "IN_BEGIN_LOC_CELL", "IN_BEGIN_LOC_TA", "IN_BEGIN_LOC_WL_CELL", "IN_BEGIN_LOC_WL_MAC", "IN_BEGIN_LOC_PROJ_TYPE",
                             "IN_BEGIN_LOC_LAT", "IN_BEGIN_LOC_LONG", "IN_END_LOC_TYPE", "IN_END_LOC_LAC", "IN_END_LOC_CELL", "IN_END_LOC_TA",
                             "IN_END_LOC_WL_CELL", "IN_END_LOC_WL_MAC", "IN_END_LOC_PROJ_TYPE", "IN_END_LOC_LAT", "IN_END_LOC_LONG", "OUT_BEGIN_LOC_TYPE",
                             "OUT_BEGIN_LOC_LAC", "OUT_BEGIN_LOC_CELL", "OUT_BEGIN_LOC_TA", "OUT_BEGIN_LOC_WL_CELL", "OUT_BEGIN_LOC_WL_MAC", "OUT_BEGIN_LOC_PROJ_TYPE",
                             "OUT_BEGIN_LOC_LAT", "OUT_BEGIN_LOC_LONG", "OUT_END_LOC_TYPE", "OUT_END_LOC_LAC", "OUT_END_LOC_CELL", "OUT_END_LOC_TA",
                             "OUT_END_LOC_WL_CELL", "OUT_END_LOC_WL_MAC", "OUT_END_LOC_PROJ_TYPE", "OUT_END_LOC_LAT", "OUT_END_LOC_LONG", "CARD_NUMBER",
                             "DIAL_DIGITS", "FORWARDING_ID", "BORDER_SWITCH_ID", "ROAM_PARTNER_ID", "MESSAGE", "SS7_OPC",
                             "SS7_DPC" };
    }

    @Override
    protected String[] getCDRItem( CDRItem cdrItem )
        throws BGException
    {
        String fromPort = cdrItem.fromPort;
        Bunch inBunch = bunches.stream()
                               .filter( b -> fromPort.equals( String.valueOf( b.getId() ) ) || fromPort.equals( b.getTitle() ) )
                               .findFirst()
                               .orElse( null );
        String toPort = cdrItem.toPort;
        Bunch outBunch = bunches.stream()
                                .filter( b -> toPort.equals( String.valueOf( b.getId() ) ) || toPort.equals( b.getTitle() ) )
                                .findFirst()
                                .orElse( null );

        String[] item = new String[97];
        item[0] = "21"; // тип сети PSTN
        item[1] = SormUtils.formatDateToUTC( cdrItem.startTime, "yyyy-MM-dd HH:mm:ss" ); //begin_time
        item[2] = String.valueOf( cdrItem.duration ); //DURATION
        item[3] = "1"; // CALL_TYPE_ID
        item[4] = getServiceId(); //SUPP_SVC_ID код ДВО
        item[5] = isOurNumber( cdrItem.callingNumber ) ? "0" : "3"; //IN_ABN_TYPE
        item[6] = isOurNumber( cdrItem.calledNumber ) ? "0" : "3"; //OUT_ABN_TYPE
        item[7] = "16"; //TERM_CAUSE
        item[8] = String.valueOf( cdrItem.deviceId ); //SWITCH_ID
        item[9] = Utils.maskBlank( cdrItem.fromPort, "1"); //IN_BUNCH
        item[10] = inBunch != null ? Utils.maskBlank( inBunch.getMac(), "" ) : ""; //IN_BUNCH_MAC
        item[11] = ""; //IN_BUNCH_VPI
        item[12] = ""; //IN_BUNCH_VCI
        item[13] = Utils.maskBlank( cdrItem.toPort, "1" ); //OUT_BUNCH
        item[14] = outBunch != null ? Utils.maskBlank( outBunch.getMac(), "" ) : ""; //OUT_BUNCH_MAC
        item[15] = ""; //OUT_BUNCH_VPI
        item[16] = ""; //OUT_BUNCH_VCI
        item[17] = "2"; //IN_INFO_ID 2 - идентификатор ТФОП
        item[18] = cdrItem.callingNumber; //IN_INFO_DIR_NUMBER
        item[19] = ""; //IN_INFO_INT_NUMBER
        item[20] = ""; //IN_INFO_IMSI
        item[21] = ""; //IN_INFO_IMEI
        item[22] = ""; //IN_INFO_MIN
        item[23] = ""; //IN_INFO_ICC
        item[24] = ""; //IN_INFO_MAC
        item[25] = ""; //IN_INFO_VPI
        item[26] = ""; //IN_INFO_VCI
        item[27] = ""; //IN_INFO_USER Имя пользователя – login
        item[28] = ""; //IN_INFO_IP_ADDR
        item[29] = ""; //IN_INFO_EMAIL
        item[30] = ""; //IN_INFO_PIN
        item[31] = ""; //IN_INFO_DOMAIN
        item[32] = ""; //IN_INFO_RESERVE
        item[33] = ""; //IN_INFO_IP_MASK
        item[34] = ""; //IN_INFO_ORIG_NAME
        item[35] = "2"; //OUT_INFO_ID
        item[36] = cdrItem.calledNumber; //OUT_INFO_DIR_NUMBER
        item[37] = ""; //OUT_INFO_INT_NUMBER
        item[38] = ""; //OUT_INFO_IMSI
        item[39] = ""; //OUT_INFO_IMEI
        item[40] = ""; //OUT_INFO_MIN
        item[41] = ""; //OUT_INFO_ICC
        item[42] = ""; //OUT_INFO_MAC
        item[43] = ""; //OUT_INFO_VPI
        item[44] = ""; //OUT_INFO_VCI
        item[45] = ""; //OUT_INFO_USER  Имя пользователя – login
        item[46] = ""; //OUT_INFO_IP_ADDR
        item[47] = ""; //OUT_INFO_EMAIL
        item[48] = ""; //OUT_INFO_PIN
        item[49] = ""; //OUT_INFO_DOMAIN
        item[50] = ""; //OUT_INFO_RESERVE
        item[51] = ""; //OUT_INFO_IP_MASK
        item[52] = ""; //OUT_INFO_ORIG_NAME
        item[53] = ""; //IN_BEGIN_LOC_TYPE
        item[54] = ""; //IN_BEGIN_LOC_LAC
        item[55] = ""; //IN_BEGIN_LOC_CELL
        item[56] = ""; //IN_BEGIN_LOC_TA
        item[57] = ""; //IN_BEGIN_LOC_WL_CELL
        item[58] = ""; //IN_BEGIN_LOC_WL_MAC
        item[59] = ""; //IN_BEGIN_LOC_PROJ_TYPE
        item[60] = ""; //IN_BEGIN_LOC_LAT
        item[61] = ""; //IN_BEGIN_LOC_LONG
        item[62] = ""; //IN_END_LOC_TYPE
        item[63] = ""; //IN_END_LOC_LAC
        item[64] = ""; //IN_END_LOC_CELL
        item[65] = ""; //IN_END_LOC_TA
        item[66] = ""; //IN_END_LOC_WL_CELL
        item[67] = ""; //IN_END_LOC_WL_MAC
        item[68] = ""; //IN_END_LOC_PROJ_TYPE
        item[69] = ""; //IN_END_LOC_LAT
        item[70] = ""; //IN_END_LOC_LONG
        item[71] = ""; //OUT_BEGIN_LOC_TYPE
        item[72] = ""; //OUT_BEGIN_LOC_LAC
        item[73] = ""; //OUT_BEGIN_LOC_CELL
        item[74] = ""; //OUT_BEGIN_LOC_TA
        item[75] = ""; //OUT_BEGIN_LOC_WL_CELL
        item[76] = ""; //OUT_BEGIN_LOC_WL_MAC
        item[77] = ""; //OUT_BEGIN_LOC_PROJ_TYPE
        item[78] = ""; //OUT_BEGIN_LOC_LAT
        item[79] = ""; //OUT_BEGIN_LOC_LONG
        item[80] = ""; //OUT_END_LOC_TYPE
        item[81] = ""; //OUT_END_LOC_LAC
        item[82] = ""; //OUT_END_LOC_CELL
        item[83] = ""; //OUT_END_LOC_TA
        item[84] = ""; //OUT_END_LOC_WL_CELL
        item[85] = ""; //OUT_END_LOC_WL_MAC
        item[86] = ""; //OUT_END_LOC_PROJ_TYPE
        item[87] = ""; //OUT_END_LOC_LAT
        item[88] = ""; //OUT_END_LOC_LONG
        item[89] = ""; //CARD_NUMBER
        item[90] = cdrItem.calledNumber; //DIAL_DIGITS  Набранный номер вызываемого абонента
        item[91] = ""; //FORWARDING_ID
        item[92] = String.valueOf( cdrItem.deviceId ); //BORDER_SWITCH_ID
        item[93] = ""; //ROAM_PARTNER_ID
        item[94] = ""; //MESSAGE
        item[95] = ""; //SS7_OPC
        item[96] = ""; //SS7_DPC
        return item;
    }
}