package ru.bitel.bgbilling.modules.tv.dyn.tv24h;

import bitel.billing.server.util.Config;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class Tv24hConf
	extends Config
{
    public enum SubscriptionMode
    {
        create,
        renew;

        public static SubscriptionMode valueOf( int id )
        {
            switch( id )
            {
                case 1:
                    return create;

                case 0:
                default:
                    return renew;
            }
        }
    }
    
    final boolean agentMode;
    final SubscriptionMode subscriptionMode;
    
	final int contractPatternId;
	final int tvAccountSpecId;

	final int paramUserId;
	final int paramNameId;
	final int paramLastNameId;
	final int paramFirstNameId;
	final int paramEmailId;
	final int paramPhoneId;

	final int chargeTypeId;
	final int paymentTypeId;
	
	final boolean providerFree;

	/**
	 * Нужно ли создавать новый договор и аккаунт, если пришёл запрос
	 * и не смогли найти договор с таким номером телефона
	 */
	final boolean isNeedCreateNewContract;

	final boolean isNeedUpdatePhoneOnContract;

	final int inetId;
	final String providerURL;

	public Tv24hConf( int moduleId, ParameterMap moduleSetup, Setup serverSetup )
	{
		super( moduleId, moduleSetup, serverSetup );
		
        this.agentMode = moduleSetup.getInt( "om.tv24h.agentMode", 1 ) > 0;
        this.subscriptionMode = SubscriptionMode.valueOf( moduleSetup.getInt( "om.tv24h.subscriptionMode", 1 ) );

		this.contractPatternId = moduleSetup.getInt( "om.tv24h.contractPatternId", 0 );
		this.tvAccountSpecId = moduleSetup.getInt( "om.tv24h.tvAccountSpecId", 0 );

		this.paramUserId = moduleSetup.getInt( "om.tv24h.param.user.id", 0 );

		this.paramNameId = moduleSetup.getInt( "om.tv24h.param.name.id", 0 );
		this.paramLastNameId = moduleSetup.getInt( "om.tv24h.param.lastName.id", 0 );
		this.paramFirstNameId = moduleSetup.getInt( "om.tv24h.param.firstName.id", 0 );

		this.paramEmailId = moduleSetup.getInt( "om.tv24h.param.email.id", 0 );
		this.paramPhoneId = moduleSetup.getInt( "om.tv24h.param.phone.id", 0 );

		this.chargeTypeId = moduleSetup.getInt( "om.tv24h.chargeTypeId", 0 );
		this.paymentTypeId = moduleSetup.getInt( "om.tv24h.paymentTypeId", 0 );
		
		this.providerFree = moduleSetup.getInt( "om.tv24h.providerFree", 0 ) > 0;
		this.isNeedCreateNewContract = moduleSetup.getInt( "om.tv24h.needCreateNewContract", 1 ) > 0;
		this.isNeedUpdatePhoneOnContract = moduleSetup.getInt( "om.tv24h.needUpdatePhone", 1 ) > 0;
		this.inetId = moduleSetup.getInt( "om.tv24h.inetMid", -1 );
		this.providerURL = getApiUrl( moduleSetup );
	}

	static public String getApiUrl(ParameterMap moduleSetup)
	{
	    return moduleSetup.get( "om.tv24h.providerURL", "https://api.24h.tv/" );
	}
}