/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.action.web;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.vidimax.common.VidimaxCharge;
import ru.bitel.bgbilling.modules.vidimax.common.service.VidimaxService;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionVidimax
extends AbstractAction {
    @Resource
    VidimaxService vidimaxService;

    public ActionVidimax() {
        super("vidimax");
    }

    @PostConstruct
    public void init() throws BGException {
        this.vidimaxService = (VidimaxService)this.context.getService(VidimaxService.class, this.moduleId);
    }

    public void execute() throws BGException {
        int status = this.req.getInt("status", 1);
        GregorianCalendar nowDate = new GregorianCalendar();
        int mm = this.req.getInt("month", nowDate.get(2) + 1);
        int yy = this.req.getInt("year", nowDate.get(1));
        Period period = new Period(yy, mm - 1, 1, 32);
        Page page = this.getPage();
        Map tariffMap = this.vidimaxService.tariffMap().getMap();
        Map serviceMap = this.vidimaxService.serviceMap().getMap();
        List list = this.vidimaxService.chargeList(this.contractId, period, page, null);
        for (VidimaxCharge el : list) {
            String tariffName = (String)tariffMap.get(el.getTariffId());
            String serTitle = serviceMap.get(el.getServiceTypeId()) != null ? ((IdTitle)serviceMap.get(el.getServiceTypeId())).getTitle() : "" + el.getServiceTypeId();
            el.setDeviceId((String)(tariffName == null ? "" + el.getTariffId() : tariffName));
            el.setPin(serTitle);
        }
        this.setResultParam("paymentList", list);
        this.setResultParam("month", mm);
        this.setResultParam("year", yy);
        this.setResultParam("page", page);
        this.setResultParam("status", String.valueOf(status));
        super.execute();
    }
}

