/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordProcessor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.LogRecordProcessor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.RangeDayFlushingManager;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.RangeProcessFlushingManager;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.SessionFlusher;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceAccountFinder;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceErrorFlusher;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceHourSessionProcessor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceRecordTarifficator;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceResourceAuditor;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceProcessLog;
import ru.bitel.bgbilling.modules.voice.server.bean.DataProccessRecordDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceProcessLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.event.LogProcessInterrupted;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.ConcurrentUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.TaskDistrubuter;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;

public class ProcessLogTask
implements Runnable,
EventListener<LogProcessInterrupted> {
    private static final Logger logger = LogManager.getLogger();
    private final LogRecordProcessor processor;
    private final DataProcessRecord record;
    private final Setup setup;
    private final int moduleId;
    private TaskDistrubuter<VoiceAccountFinder, ServerContext> finderDistrubuter = null;
    private TaskDistrubuter<VoiceRecordTarifficator, VoiceTariffWorkerContext> tarifficatorDistrubuter = null;
    private TaskDistrubuter<SessionFlusher, ServerContext> flushDistrubuter = null;
    private TaskDistrubuter<RangeDayFlushingManager, ServerContext> flushRangeDistrubuter = null;
    private ExecutorService processLogExecutor = null;
    private ExecutorService errorExecutor = null;
    private VoiceResourceAuditor resourceAuditor;
    private int tarificatorCount = 1;
    private int finderCount = 3;
    private int rangeFlushCount = 3;
    private VoiceDeviceRuntime deviceRuntime;
    int recordArrayCount = 50;
    int recordArraySize = 1000;
    int tarificatorSize = 100;
    int errorSize = 200000;
    private VoiceTariffContext tariffContext = null;

    public ProcessLogTask(LogRecordProcessor processor, DataProcessRecord record, Setup setup, int moduleId) {
        this.processor = processor;
        this.record = record;
        this.setup = setup;
        this.moduleId = moduleId;
        this.deviceRuntime = processor.getDeviceRuntimeMap().get(record.getDeviceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.info(ProcessLogTask.class.getName() + " started");
            if (!TimeUtils.dateInRange((Date)this.record.getDay(), (Date)this.deviceRuntime.getDevice().getDateFrom(), (Date)this.deviceRuntime.getDevice().getDateTo())) {
                logger.info("Skip, " + this.record.getDay().toString() + " not in device period [" + this.deviceRuntime.getDevice().getDateFrom().toString() + "-" + this.deviceRuntime.getDevice().getDateTo().toString() + "]");
                return;
            }
            long startTime = System.currentTimeMillis();
            EventProcessor.getInstance().addListener((EventListener)this, LogProcessInterrupted.class, this.moduleId, null);
            ServerContext parentContext = (ServerContext)ServerContext.get();
            try (ServerContext context = new ServerContext(this.setup, this.moduleId, 0);){
                ServerContext.set((ThreadContext)context);
                this.tariffContext = new VoiceTariffContext(this.record.getDay(), this.moduleId, context.getConnection());
                this.initResourceAuditor(context.getConnection());
            }
            finally {
                ServerContext.set((ThreadContext)parentContext);
            }
            this.processLogExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new WorkerThreadFactory("processLog", null, null));
            ServerContextThreadFactory finderContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, null, null, true);
            this.finderDistrubuter = new TaskDistrubuter(this.finderCount, this.setup, (ThreadContextFactory)finderContextFactory, "finder");
            ThreadContextFactory tarificatorContextFactory = () -> new VoiceTariffWorkerContext(this.setup, ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true), this.moduleId);
            this.tarifficatorDistrubuter = new TaskDistrubuter(this.tarificatorCount, this.setup, tarificatorContextFactory, "tarifficator");
            ServerContextThreadFactory flushContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, null, null, true);
            this.flushDistrubuter = new TaskDistrubuter(this.tarificatorCount, this.setup, (ThreadContextFactory)flushContextFactory, "flusher");
            ServerContextThreadFactory flushRangeContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, null, null, true);
            this.flushRangeDistrubuter = new TaskDistrubuter(this.rangeFlushCount, this.setup, (ThreadContextFactory)flushRangeContextFactory, "rangeFlusher");
            this.errorExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new ServerContextThreadFactory(this.setup, this.moduleId, "errorLogs", null, true));
            Date now = new Date();
            int daylDelta = TimeUtils.daysDelta((Date)now, (Date)this.record.getDay());
            if (daylDelta > 0) {
                return;
            }
            boolean isCurrentDay = daylDelta == 0;
            int currentHour = TimeUtils.convertDateToCalendar((Date)now).get(11);
            Calendar cal = TimeUtils.convertDateToCalendar((Date)this.record.getDay());
            int hourMax = isCurrentDay ? currentHour : 24;
            try (Connection con = this.setup.getDBConnectionFromPool();
                 VoiceSessionLogDao voiceSessionLogDao = new VoiceSessionLogDao(con, this.moduleId, cal.getTime());){
                cal.set(11, 0);
                voiceSessionLogDao.deleteSessions(TimeUtils.convertDateToLocalDate((Date)cal.getTime()), this.record.getDeviceId());
            }
            con = this.setup.getDBConnectionFromPool();
            try (DataProccessRecordDao dataProccessRecordDao = new DataProccessRecordDao(con, this.moduleId);){
                for (int j = 0; j < hourMax; j = (int)((byte)(j + 1))) {
                    cal.set(11, j);
                    this.processHour(cal.getTime());
                    if (j >= 23 && !isCurrentDay) continue;
                    this.record.setCurrentHour((byte)(j + 1));
                    dataProccessRecordDao.update(this.record);
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
            this.finderDistrubuter.finish();
            this.tarifficatorDistrubuter.finish();
            this.flushDistrubuter.finish();
            for (int i = 0; i < this.rangeFlushCount; ++i) {
                this.flushRangeDistrubuter.putNextTask((Callable)new RangeDayFlushingManager(this.record.getDay(), this.moduleId, i, this.rangeFlushCount, this.tariffContext, null));
            }
            this.flushRangeDistrubuter.finish();
            RangeProcessFlushingManager manager = new RangeProcessFlushingManager(this.setup, this.tariffContext, this.moduleId);
            manager.flushMonthRangeFromDBDetail(TimeUtils.getStartMonth((Date)this.record.getDay()));
            this.addTaskProccesedMark();
            logger.info(ProcessLogTask.class.getName() + "ended in " + TimeUtils.formatDeltaTime((long)((System.currentTimeMillis() - startTime) / 1000L)) + " millis");
        }
        catch (Throwable e) {
            logger.error("fatal error in " + this.getClass().getName(), e);
        }
        finally {
            try {
                EventProcessor.getInstance().removeListener((EventListener)this);
            }
            catch (BGException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.processLogExecutor != null) {
                    this.processLogExecutor.shutdown();
                    this.processLogExecutor.awaitTermination(40L, TimeUnit.MINUTES);
                }
                if (this.errorExecutor != null) {
                    this.errorExecutor.shutdown();
                    this.errorExecutor.awaitTermination(40L, TimeUnit.MINUTES);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.removeTask(this.record);
        }
    }

    private void addTaskProccesedMark() throws BGException {
        try (ConnectionSet conSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
             VoiceProcessLogDao dao = new VoiceProcessLogDao(conSet.getConnection(), this.moduleId);){
            if (logger.isDebugEnabled()) {
                logger.debug("addTaskProccesedMark( deviceId={}; day={} )", (Object)this.record.getDeviceId(), (Object)this.record.getDay());
            }
            VoiceProcessLog log = new VoiceProcessLog();
            log.setDeviceId(this.record.getDeviceId());
            log.setDay(this.record.getDay());
            dao.update(log);
        }
    }

    private void initResourceAuditor(Connection con) throws BGException {
        this.resourceAuditor = new VoiceResourceAuditor(this.moduleId);
        ParameterMap config = this.deviceRuntime.getConfig();
        String categories = config != null ? config.get("cdr.audit.resource.categories", this.setup.getModuleSetup(Integer.valueOf(this.moduleId)).get("cdr.audit.resource.categories")) : null;
        this.resourceAuditor.load(con, categories != null ? Utils.toIntegerSet(categories) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processHour(Date hour) throws InterruptedException, ExecutionException {
        long startTime = System.currentTimeMillis();
        VoiceRecordProcessor recordProcessor = new VoiceRecordProcessor(this.recordArrayCount, this.recordArraySize, this.finderCount);
        VoiceHourSessionProcessor sessionProcessor = new VoiceHourSessionProcessor(recordProcessor, this.tarificatorCount, this.tarificatorSize, this.errorSize, this.record, hour);
        ArrayList<Future> tariffAndFindFutures = new ArrayList<Future>();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        try {
            int i;
            futures.add(this.parseHourLog(hour, recordProcessor));
            VoiceAccountRuntimeMap accountRuntimeMap = this.processor.getAccountRuntimeMap(this.record.getDay());
            VoiceOperAccountRuntimeMap operAccountRuntimeMap = this.processor.getOperAccountRuntimeMap(this.record.getDay());
            for (i = 0; i < this.finderCount; ++i) {
                tariffAndFindFutures.add(this.finderDistrubuter.putNextTask((Callable)new VoiceAccountFinder(this.deviceRuntime, sessionProcessor, accountRuntimeMap, operAccountRuntimeMap, this.resourceAuditor, this.processor.getOperatorRuntimeMap())));
            }
            for (i = 0; i < this.tarificatorCount; ++i) {
                tariffAndFindFutures.add(this.tarifficatorDistrubuter.putNextTask((Callable)new VoiceRecordTarifficator(this.processor, sessionProcessor, i, this.tariffContext)));
            }
            for (i = 0; i < this.tarificatorCount; ++i) {
                futures.add(this.flushDistrubuter.putNextTask((Callable)new SessionFlusher(sessionProcessor, i)));
            }
            futures.add(this.errorExecutor.submit(new VoiceErrorFlusher(sessionProcessor)));
        }
        finally {
            ConcurrentUtils.awaitFutures(tariffAndFindFutures);
            sessionProcessor.finishErrorTasks();
            ConcurrentUtils.awaitFutures(futures);
            logger.info("Hour " + hour + " ended in " + TimeUtils.formatDeltaTime((long)((System.currentTimeMillis() - startTime) / 1000L)) + " millis");
        }
    }

    private Future<Object> parseHourLog(Date hour, VoiceRecordProcessor recordProcessor) {
        return this.processLogExecutor.submit(() -> {
            boolean interrupted = false;
            Object mediator = null;
            try {
                if (this.deviceRuntime == null) {
                    logger.error("device is null  ");
                    Object var5_5 = null;
                    return var5_5;
                }
                mediator = this.deviceRuntime.getMediatorInstance();
                if (mediator == null) {
                    logger.error("device with id = " + this.deviceRuntime.getDevice().getId() + " has empty Mediator ");
                    Object var5_6 = null;
                    return var5_6;
                }
                mediator.readHourDataLog(recordProcessor, hour);
            }
            catch (InterruptedException ex) {
                logger.error(mediator.getClass().getName() + " was interrupted");
                interrupted = true;
            }
            catch (Exception e) {
                logger.error("error while proccesing " + mediator.getClass().getName(), (Throwable)e);
            }
            finally {
                if (!interrupted) {
                    recordProcessor.finish();
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(DataProcessRecord record) {
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            try (DataProccessRecordDao dataProccessRecordDao = new DataProccessRecordDao(con, this.moduleId);){
                dataProccessRecordDao.delete(record.getDeviceId(), Arrays.asList(record.getDay()));
            }
        }
        catch (BGException ex) {
            logger.error("error while closing connection", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public void notify(LogProcessInterrupted e, EventListenerContext ctx) throws BGException {
        logger.error("ProcessLogTask is interrupted!!!");
        this.interrupt(this.flushDistrubuter);
        this.interrupt(this.tarifficatorDistrubuter);
        this.interrupt(this.finderDistrubuter);
        this.processLogExecutor.shutdownNow();
        this.processLogExecutor.shutdownNow();
    }

    public void interrupt(TaskDistrubuter<?, ?> distributer) {
        try {
            distributer.interrupt();
        }
        catch (InterruptedException iex) {
            logger.error(iex.getMessage(), (Throwable)iex);
        }
    }

    public VoiceTariffContext getTariffContext() {
        return this.tariffContext;
    }
}

