/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import au.com.bytecode.opencsv.CSVWriter;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetail;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetailReportItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.template.jsp.JspTemplate;

public class VoiceSessionExporter {
    private static Logger logger = LogManager.getLogger(VoiceSessionExporter.class);

    public InputStream htmlDetailExport(Contract contract, Period period, Result<?> result, ServletContext context) throws BGException {
        return this.htmlExport(contract, period, result, context, "jspf/voice/voice_detail.jsp", Collections.emptyMap());
    }

    public InputStream htmlSessionExport(Contract contract, Period period, Result<?> result, ServletContext context, Map<Integer, VoiceDestination> destinationMap) throws BGException {
        return this.htmlExport(contract, period, result, context, "jspf/voice/voice_sessions.jsp", Collections.singletonMap("destinationMap", destinationMap));
    }

    private InputStream htmlExport(final Contract contract, final Period period, final Result<?> result, final ServletContext context, final String path, final Map<String, Object> params) throws BGException {
        PipedInputStream htmlStream = new PipedInputStream(51200);
        try {
            final PipedOutputStream output = new PipedOutputStream(htmlStream);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        VoiceSessionExporter.this.htmlDetailExportEnternal(contract, period, result, output, context, path, params);
                    }
                    catch (IOException e) {
                        logger.error("", (Throwable)e);
                    }
                    finally {
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            logger.error("", (Throwable)e);
                        }
                    }
                }
            }, "session-html-export").start();
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        return htmlStream;
    }

    private void htmlDetailExportEnternal(Contract contract, Period period, Result<?> result, OutputStream output, ServletContext context, String path, Map<String, Object> params) throws IOException {
        JspTemplate template = JspTemplate.getTemplate((ServletContext)context, (String)path);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("contract", contract);
        attributes.put("result", result);
        attributes.put("dateFrom", period.getDateFrom());
        attributes.put("dateTo", TimeUtils.getPrevDay((Date)period.getDateTo()));
        params.forEach((k, v) -> attributes.put((String)k, v));
        template.transform(attributes, output);
        output.flush();
    }

    public InputStream csvExport(final Result<VoiceSession> sessionLogContractList, final char separator, final Map<Integer, VoiceDestination> destinationsMap) throws BGException {
        PipedOutputStream output;
        PipedInputStream csvStream = new PipedInputStream(51200);
        try {
            output = new PipedOutputStream(csvStream);
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    VoiceSessionExporter.this.csvExportEnternal((Result<VoiceSession>)sessionLogContractList, output, separator, destinationsMap);
                }
                catch (BGException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }, "session-csv-export").start();
        return csvStream;
    }

    private void csvExportEnternal(Result<VoiceSession> sessionLogContractList, OutputStream output, char separator, Map<Integer, VoiceDestination> destinationsMap) throws BGException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
            CSVWriter csv = new CSVWriter((Writer)writer, separator);
            String[] csvHeaderArray = new String[]{"\u041a\u043e\u0434 \u0441\u0435\u0441\u0441\u0438\u0438", "\u0410\u043a\u043a\u0430\u0443\u043d\u0442", "\u0422\u0438\u043f", "\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", "\u041d\u043e\u043c\u0435\u0440 A", "\u041d\u043e\u043c\u0435\u0440 B", "\u041d\u043e\u043c\u0435\u0440 A#e164", "\u041d\u043e\u043c\u0435\u0440 B#e164", "\u0421\u0442\u0430\u0440\u0442", "\u0421\u0442\u043e\u043f", "\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043e\u043a\u0440.", "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", "\u0447\u0430\u0441", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", "AccountSessionId"};
            int columntCount = csvHeaderArray.length;
            csv.writeNext(csvHeaderArray, false);
            DateFormat dateFormat1 = TimeUtils.getDateFormat((String)"dd.MM.yyyy HH:mm:ss");
            DateFormat dateFormat2 = TimeUtils.getDateFormat((String)"dd.MM.yyyy HH");
            for (VoiceSession session : sessionLogContractList.getList()) {
                int index = 0;
                String[] csvStringArray = new String[columntCount];
                csvStringArray[index++] = String.valueOf(session.getId());
                csvStringArray[index++] = session.getAccountTitle();
                csvStringArray[index++] = session.getCallType() == 1 ? ">>" : "<<";
                VoiceDestination voiceDestination = destinationsMap.get(session.getDestinationId());
                csvStringArray[index++] = voiceDestination != null ? voiceDestination.getTitle() : "";
                csvStringArray[index++] = session.getCallingStationId();
                csvStringArray[index++] = session.getCalledStationId();
                csvStringArray[index++] = session.getE164CallingStationId();
                csvStringArray[index++] = session.getE164CalledStationId();
                csvStringArray[index++] = TimeUtils.format((Date)session.getSessionStart(), (DateFormat)dateFormat1);
                csvStringArray[index++] = TimeUtils.format((Date)session.getSessionStop(), (DateFormat)dateFormat1);
                csvStringArray[index++] = TimeUtils.format((Date)session.getLastActive(), (DateFormat)dateFormat1);
                csvStringArray[index++] = Utils.formatSessionTime((int)((int)session.getSessionTime()));
                csvStringArray[index++] = Utils.formatSessionTime((int)((int)session.getRoundedSessionTime()));
                csvStringArray[index++] = session.getSessionCost().toString();
                csvStringArray[index++] = TimeUtils.format((Date)session.getHour(), (DateFormat)dateFormat2);
                csvStringArray[index++] = session.getIdentifier();
                csvStringArray[index++] = session.getAcctSessionId();
                csv.writeNext(csvStringArray, false);
            }
            try {
                csv.flush();
                csv.close();
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public InputStream csvDetailExport(final Result<SessionDetail<SessionDetail<SessionDetailReportItem>>> result, final char separator) throws BGException {
        PipedOutputStream output;
        PipedInputStream csvStream = new PipedInputStream(51200);
        try {
            output = new PipedOutputStream(csvStream);
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    VoiceSessionExporter.this.csvDetailExportEnternal((Result<SessionDetail<SessionDetail<SessionDetailReportItem>>>)result, output, separator);
                    output.close();
                }
                catch (IOException | BGException e) {
                    logger.error("", e);
                }
            }
        }, "session-csv-export").start();
        return csvStream;
    }

    private void csvDetailExportEnternal(Result<SessionDetail<SessionDetail<SessionDetailReportItem>>> result, OutputStream output, char separator) throws BGException {
        try {
            String[] csvStringArray;
            OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
            CSVWriter csv = new CSVWriter((Writer)writer, separator);
            String[] csvHeaderArray = new String[]{"", "\u0412\u0440\u0435\u043c\u044f", "\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", "\u041d\u043e\u043c\u0435\u0440 A", "\u041d\u043e\u043c\u0435\u0440 B", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c, \u043e\u043a\u0440.", "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c"};
            int columntCount = csvHeaderArray.length;
            csv.writeNext(csvHeaderArray);
            int index = 0;
            for (SessionDetail detailService : result.getList()) {
                index = 0;
                csvStringArray = new String[columntCount];
                csvStringArray[index++] = "\u0423\u0441\u043b\u0443\u0433\u0430";
                csvStringArray[index++] = detailService.getService();
                csv.writeNext(csvStringArray, false);
                for (SessionDetail detailNumber : detailService.getResult()) {
                    index = 0;
                    csvStringArray = new String[columntCount];
                    csvStringArray[index++] = "\u041d\u043e\u043c\u0435\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430:";
                    csvStringArray[index++] = detailNumber.getNumberA();
                    csv.writeNext(csvStringArray, false);
                    for (SessionDetailReportItem item : detailNumber.getResult()) {
                        index = 0;
                        csvStringArray = new String[columntCount];
                        csvStringArray[index++] = "";
                        csvStringArray[index++] = TimeUtils.format((Date)item.getSessionStart(), (String)"yyyy-MM-dd HH:mm:ss");
                        csvStringArray[index++] = item.getDestination();
                        csvStringArray[index++] = item.getNumberA();
                        csvStringArray[index++] = item.getNumberB();
                        csvStringArray[index++] = Utils.formatSessionTime((int)item.getDuration());
                        csvStringArray[index++] = Utils.formatSessionTime((int)item.getDurationRound());
                        csvStringArray[index++] = Utils.maskNull((BigDecimal)item.getCost()).toString();
                        csv.writeNext(csvStringArray, false);
                    }
                    index = 0;
                    csvStringArray = new String[columntCount];
                    csvStringArray[index++] = "\u0418\u0442\u043e\u0433\u043e \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443:";
                    csvStringArray[index++] = "";
                    csvStringArray[index++] = String.valueOf(detailNumber.getCount());
                    csvStringArray[index++] = "";
                    csvStringArray[index++] = String.valueOf(detailNumber.getAmount() / 60L);
                    csvStringArray[index++] = String.valueOf(detailNumber.getAmountRound() / 60L);
                    csvStringArray[index++] = Utils.maskNull((BigDecimal)detailNumber.getSumm()).toString();
                    csv.writeNext(csvStringArray, false);
                }
                index = 0;
                csvStringArray = new String[columntCount];
                csvStringArray[index++] = "\u0418\u0442\u043e\u0433\u043e \u043f\u043e \u0443\u0441\u043b\u0443\u0433\u0435:";
                csvStringArray[index++] = "";
                csvStringArray[index++] = String.valueOf(detailService.getCount());
                csvStringArray[index++] = "";
                csvStringArray[index++] = String.valueOf(detailService.getAmount() / 60L);
                csvStringArray[index++] = String.valueOf(detailService.getAmountRound() / 60L);
                csvStringArray[index++] = Utils.maskNull((BigDecimal)detailService.getSumm()).toString();
                csv.writeNext(csvStringArray, false);
            }
            index = 0;
            csvStringArray = new String[columntCount];
            csvStringArray[index++] = "\u0418\u0442\u043e\u0433\u043e:";
            csvStringArray[index++] = "";
            csvStringArray[index++] = String.valueOf(result.getAttribute("totalCount"));
            csvStringArray[index++] = "";
            csvStringArray[index++] = String.valueOf((Long)result.getAttribute("totalTime") / 60L);
            csvStringArray[index++] = String.valueOf((Long)result.getAttribute("totalTimeRound") / 60L);
            csvStringArray[index++] = result.getAttribute("totalSum").toString();
            csv.writeNext(csvStringArray, false);
            try {
                csv.flush();
                csv.close();
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

