/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.worker.ThreadContext;

public abstract class CallTypeCostTariffTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, TariffContext> {
    private static final Logger logger = LogManager.getLogger();
    public static final int COST_SOURCE_NODE = 1;
    public static final int COST_SOURCE_CDR = 2;
    public static final int COST_SOURCE_COSTMAP = 3;
    public static final int COST_SOURCE_TARIFF_VAR = 4;
    public static final int COST_SOURCE_ZONE_COST_MAP = 5;
    private final int callType;
    private final boolean clientCost;
    private final BigDecimal cost;
    private boolean isDefault = false;
    private int costSource = 1;
    private BigDecimal divisor = BigDecimal.ONE;
    private final int tariffVarId;

    protected CallTypeCostTariffTreeNode(int id, ParameterMap parameterMap, boolean clientCost, int callType) {
        super(id, parameterMap);
        this.callType = parameterMap.getInt("callType", callType);
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
        this.clientCost = clientCost;
        BigDecimal cost = null;
        try {
            cost = parameterMap.getBigDecimal("cost", null);
            this.isDefault = parameterMap.get("default", null) != null;
            this.divisor = parameterMap.getBigDecimal("cost_divisor", BigDecimal.ONE);
            String source = parameterMap.get("cost_source", null);
            if (source != null) {
                if ("cdr".equals(source)) {
                    this.costSource = 2;
                } else if ("costMap".equals(source)) {
                    this.costSource = 3;
                } else if ("tariffVar".equals(source)) {
                    this.costSource = 4;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cost == null) {
            try {
                cost = parameterMap.getBigDecimal("", BigDecimal.ZERO);
                this.isDefault = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cost = cost;
        if (logger.isDebugEnabled()) {
            logger.debug("this.cost = " + this.cost);
            logger.debug("this.costSource = " + this.costSource);
            logger.debug("this.divisor = " + this.divisor);
            logger.debug("this.callType = " + this.callType);
            logger.debug("this.clientCost = " + this.clientCost);
            logger.debug("this.isDefault = " + this.isDefault);
        }
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, VoiceTariffRequest voiceTariffRequest, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        BigDecimal secondCost;
        BigDecimal cost;
        int costSource;
        int result = 0;
        VoiceServiceCost serviceCost = this.clientCost ? (VoiceServiceCost)voiceTariffRequest.serviceCost : voiceTariffRequest.operServiceCost;
        boolean acceptInParent = serviceCost.acceptLevel > holder.level;
        boolean acceptDefault = serviceCost.acceptDefault;
        if (this.costSource == 2 && this.clientCost) {
            costSource = 2;
            secondCost = cost = voiceTariffRequest.getVoiceSessionRuntime().getSession().getCdrCallCost();
        } else {
            if (this.costSource == 3) {
                costSource = 1;
                BigDecimal bdCost = voiceTariffRequest.costMapCost;
                if (bdCost != null) {
                    cost = bdCost;
                    serviceCost.costMapItemId = voiceTariffRequest.costMapItemId;
                } else {
                    cost = this.cost;
                }
            } else if (this.costSource == 4) {
                String value;
                costSource = 1;
                ContractTariffVar contractTariffVar = voiceTariffRequest.getContractTariffVar(this.tariffVarId);
                cost = contractTariffVar != null ? new BigDecimal((value = contractTariffVar.getValue()) == null ? contractTariffVar.getDefaultValue() : value) : this.cost;
            } else {
                costSource = this.costSource;
                cost = this.cost;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("cost(1) = " + cost + " [B=" + voiceTariffRequest.getPhoneTo() + "]");
            }
            secondCost = cost.divide(this.divisor, ctx.mc);
            if (logger.isTraceEnabled()) {
                logger.trace("secondCost = " + secondCost + " [B=" + voiceTariffRequest.getPhoneTo() + "]");
            }
            if (cost != null && voiceTariffRequest.serviceCost != null) {
                cost = this.divisor.compareTo(BigDecimal.ONE) != 0 ? cost.multiply(BigDecimal.valueOf(((VoiceServiceCost)voiceTariffRequest.serviceCost).getAmount()), ctx.mc).divide(this.divisor, ctx.mc) : cost.multiply(BigDecimal.valueOf(((VoiceServiceCost)voiceTariffRequest.serviceCost).getAmount()), ctx.mc);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("cost(2) = " + cost + " [B=" + voiceTariffRequest.getPhoneTo() + "]");
                logger.debug("voiceTariffRequest.serviceCost.amount = " + ((VoiceServiceCost)voiceTariffRequest.serviceCost).getAmount());
            }
        }
        if (!this.isDefault) {
            serviceCost.setCost(cost);
            serviceCost.divisor = this.divisor;
            serviceCost.costSource = costSource;
            serviceCost.acceptLevel = -1;
            serviceCost.acceptDefault = false;
            serviceCost.secondCost = secondCost;
        } else if (serviceCost.getCost() == null || acceptDefault && acceptInParent) {
            serviceCost.setCost(cost);
            serviceCost.divisor = this.divisor;
            serviceCost.costSource = costSource;
            serviceCost.acceptLevel = holder.level;
            serviceCost.acceptDefault = true;
        }
        return this.postExecute(treeNodeId, parentTreeNodeId, voiceTariffRequest, holder, ctx, treeContext, workerContext, result);
    }

    protected final int executeImpl(Long treeNodeId, VoiceTariffRequest req, TariffContext ctx) {
        throw new UnsupportedOperationException();
    }
}

