/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class PortFilterTariffTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, TariffContext> {
    private Set<String> portOutSet = new HashSet<String>();
    private Set<String> portInSet = new HashSet<String>();

    public PortFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String inPorts;
        String outPorts = parameterMap.get("port_to", null);
        if (Utils.notBlankString((String)outPorts)) {
            this.portOutSet.addAll(Utils.toList((String)outPorts));
            this.logger.debug("ports_to = {} {}", (Object)this.portOutSet.size(), (Object)this.portOutSet.iterator().next());
        }
        if (Utils.notBlankString((String)(inPorts = parameterMap.get("port_from", null)))) {
            this.portInSet.addAll(Utils.toList((String)inPorts));
            this.logger.debug("ports_from = {} {}", (Object)this.portInSet.size(), (Object)this.portInSet.iterator().next());
        }
    }

    protected int executeImpl(Long treeNodeId, VoiceTariffRequest voiceTariffRequest, TariffContext context) {
        String portTo = voiceTariffRequest.getPortTo();
        String portFrom = voiceTariffRequest.getPortFrom();
        this.logger.debug("port_from={} port_to={}", (Object)portFrom, (Object)portTo);
        if ((portTo == null || this.portOutSet.size() == 0 || this.portOutSet.contains(portTo)) && (portFrom == null || this.portInSet.size() == 0 || this.portInSet.contains(portFrom))) {
            this.logger.debug("portOutSet.contains( portTo ) = {}", (Object)this.portOutSet.contains(portTo));
            return 1;
        }
        return 0;
    }
}

