/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.bean.VoiceTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;

public class TariffConfigTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, VoiceTariffContext> {
    private final Logger logger = LogManager.getLogger();
    protected final VoiceTariffConfig config;

    public TariffConfigTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.config = new VoiceTariffConfig(parameterMap.get("", ""));
    }

    protected int executeImpl(Long treeNodeId, VoiceTariffRequest voiceTariffRequest, VoiceTariffContext voiceTariffContext) {
        VoiceServiceCost serviceCost;
        voiceTariffRequest.setConfig(this.config);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("config.isUseRound() = " + this.config.isUseRound());
        }
        if (this.config.isUseRound() && (serviceCost = (VoiceServiceCost)voiceTariffRequest.serviceCost) != null) {
            int amount = (int)serviceCost.getAmount();
            ((VoiceServiceCost)voiceTariffRequest.serviceCost).setAmount(this.config.getRoundTime(amount));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("voiceTariffRequest.serviceCost.amount: " + amount + " -> " + ((VoiceServiceCost)voiceTariffRequest.serviceCost).getAmount());
            }
        }
        return 1;
    }
}

