/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;

public class VoiceMultCostTariffTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, TariffContext> {
    private static final Logger logger = LogManager.getLogger();
    private final BigDecimal multiplicand;

    public VoiceMultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        if (logger.isDebugEnabled()) {
            logger.debug("multiplicand = " + this.multiplicand);
        }
    }

    public int executeImpl(Long treeNodeId, VoiceTariffRequest voiceTariffRequest, TariffContext tariffContext) {
        int result = 0;
        for (VoiceServiceCost voiceServiceCost : voiceTariffRequest.getServiceCostList()) {
            if (voiceServiceCost.getCost() == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("voiceServiceCost.serviceId = " + voiceServiceCost.getServiceId());
                logger.debug("voiceServiceCost.cost(before) = " + voiceServiceCost.getCost());
                logger.debug("voiceServiceCost.secondCost(before) = " + voiceServiceCost.secondCost);
            }
            voiceServiceCost.setCost(voiceServiceCost.getCost().multiply(this.multiplicand, tariffContext.mc));
            voiceServiceCost.secondCost = voiceServiceCost.secondCost.multiply(this.multiplicand, tariffContext.mc);
            if (logger.isDebugEnabled()) {
                logger.debug("voiceServiceCost.cost(after) = " + voiceServiceCost.getCost());
                logger.debug("voiceServiceCost.secondCost(after) = " + voiceServiceCost.secondCost);
            }
            result = 1;
        }
        return result;
    }
}

