/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class VoiceAccountTypePanel
extends BGUPanel {
    private List<Status> list = null;
    private VoiceAccountTypeTableModel typeTableModel;

    public VoiceAccountTypePanel() {
        this.setLayout(new BorderLayout());
    }

    protected void jbInit() throws Exception {
        this.typeTableModel = new VoiceAccountTypeTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.typeTableModel));
        this.setLayout(new BorderLayout());
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "refresh", "refresh", e -> this.typeTableModel.setData(this.getVoiceAccountTypeList()));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new VoiceAccountTypeEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", new VoiceAccountType()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.typeTableModel, VoiceAccountTypeEditorDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "delete", "delete", e -> {
            VoiceAccountType selectedType = (VoiceAccountType)this.typeTableModel.getSelectedRow();
            if (selectedType == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u0442\u0430 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", 0) == 0) {
                try {
                    ((ClientContext)this.getContext()).getDirectory(VoiceAccountType.class).delete(selectedType.getId());
                    this.performAction("refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
    }

    private List<VoiceAccountType> getVoiceAccountTypeList() {
        try {
            return ((ClientContext)this.getContext()).getDirectory(VoiceAccountType.class).list();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return new ArrayList<VoiceAccountType>();
        }
    }

    class VoiceAccountTypeTableModel
    extends BGTableModel<VoiceAccountType> {
        public VoiceAccountTypeTableModel() {
            super(VoiceAccountTypeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430", "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class VoiceAccountTypeEditorDialog
    extends BGEditorDialog<VoiceAccountType> {
        private BGTextField typeTitleTextField;
        private BGUComboBox<EntitySpec> entitySpec;
        private IntTextField sessionCountLimit;
        private JCheckBox sessionCountLimitLock;
        private BGConfigEditorPane config;
        private JCheckBox needLogin;
        private JCheckBox needPassword;
        private JCheckBox needPhone;
        private JCheckBox needLines;
        private JCheckBox needDevice;
        private JCheckBox needPorts;
        private JCheckBox needObject;
        private JComboBox<Status> cellEditorComboBox;
        private StatusTableModel statusTableModel;
        private JCheckBox status;

        public VoiceAccountTypeEditorDialog(String title, VoiceAccountType data) {
            super(title, (Object)data);
            this.typeTitleTextField = new BGTextField(40);
            this.entitySpec = new BGUComboBox();
            this.sessionCountLimit = new IntTextField();
            this.sessionCountLimitLock = new JCheckBox("\u043d\u0435\u0438\u0437\u043c\u0435\u043d\u043d\u043e");
            this.config = new BGConfigEditorPane();
            this.needLogin = new JCheckBox("\u043b\u043e\u0433\u0438\u043d");
            this.needPassword = new JCheckBox("\u043f\u0430\u0440\u043e\u043b\u044c");
            this.needPhone = new JCheckBox("\u043d\u043e\u043c\u0435\u0440");
            this.needLines = new JCheckBox("\u043b\u0438\u043d\u0438\u0438");
            this.needDevice = new JCheckBox("\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            this.needPorts = new JCheckBox("\u043f\u043e\u0440\u0442\u044b");
            this.needObject = new JCheckBox("\u043e\u0431\u044a\u0435\u043a\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.cellEditorComboBox = new JComboBox();
            this.statusTableModel = new StatusTableModel();
            this.status = new JCheckBox("\u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.cellEditorComboBox.setRenderer(new ListCellRenderer<Status>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends Status> list, Status value, int index, boolean isSelected, boolean cellHasFocus) {
                    return new JLabel(value.getGuiTitle());
                }
            });
        }

        public void doDialogPanel() {
            String statusConfig;
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("\u041e\u0431\u0448\u0438\u0435", BGSwingUtilites.wrapEmptyBorder((JComponent)this.getGeneralPanel()));
            tabbedPane.add("\u0421\u0442\u0430\u0442\u0443\u0441", this.getStatusPanel());
            tabbedPane.add("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", this.getConfigPanel());
            this.panel.add((Component)tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.initEntitySpec();
            this.typeTitleTextField.setText(((VoiceAccountType)this.data).getTitle());
            this.sessionCountLimit.setValue((long)((VoiceAccountType)this.data).getSessionCountLimit());
            this.sessionCountLimitLock.setSelected(((VoiceAccountType)this.data).isSessionCountLimitLock());
            this.entitySpec.setSelectedItem((Object)((VoiceAccountType)this.data).getEntitySpecId());
            this.config.setText(((VoiceAccountType)this.data).getConfig());
            this.needPassword.setSelected(((VoiceAccountType)this.data).isCheckPassword());
            this.needLogin.setSelected(((VoiceAccountType)this.data).isNeedLogin());
            this.needPhone.setSelected(((VoiceAccountType)this.data).isNeedPhone());
            this.needPorts.setSelected(((VoiceAccountType)this.data).isNeedPorts());
            this.needDevice.setSelected(((VoiceAccountType)this.data).isNeedDevice());
            this.needObject.setSelected(((VoiceAccountType)this.data).isNeedObject());
            this.needLines.setSelected(((VoiceAccountType)this.data).isNeedLines());
            if (VoiceAccountTypePanel.this.list == null) {
                try {
                    VoiceAccountTypePanel.this.list = ((ContractStatusService)((ClientContext)VoiceAccountTypePanel.this.getContext()).getPort(ContractStatusService.class, 0)).getStatusList(false);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            JSONObject statusJson = new JSONObject((statusConfig = ((VoiceAccountType)this.data).getStatusConfig()) == null || statusConfig.isEmpty() ? "{}" : statusConfig);
            this.status.setSelected(statusJson.optBoolean("mode", false));
            ArrayList statusData = new ArrayList();
            JSONArray rules = statusJson.optJSONArray("rules");
            if (rules != null) {
                rules.forEach(i -> statusData.add((JSONObject)i));
            }
            this.statusTableModel.setData(statusData);
        }

        public boolean doApply() throws Exception {
            JSONObject statusJson = new JSONObject();
            statusJson.put("mode", this.status.isSelected());
            JSONArray rules = new JSONArray();
            this.statusTableModel.getRows().forEach(r -> rules.put(r));
            statusJson.put("rules", (Object)rules);
            ((VoiceAccountType)this.data).setTitle(this.typeTitleTextField.getText());
            ((VoiceAccountType)this.data).setSessionCountLimit((byte)this.sessionCountLimit.getValue());
            ((VoiceAccountType)this.data).setSessionCountLimitLock(this.sessionCountLimitLock.isSelected());
            ((VoiceAccountType)this.data).setEntitySpecId(((EntitySpec)this.entitySpec.getSelectedItem()).getId());
            ((VoiceAccountType)this.data).setConfig(this.config.getText());
            ((VoiceAccountType)this.data).setCheckPassword(this.needPassword.isSelected());
            ((VoiceAccountType)this.data).setNeedLogin(this.needLogin.isSelected());
            ((VoiceAccountType)this.data).setNeedLines(this.needLines.isSelected());
            ((VoiceAccountType)this.data).setNeedPhone(this.needPhone.isSelected());
            ((VoiceAccountType)this.data).setNeedPorts(this.needPorts.isSelected());
            ((VoiceAccountType)this.data).setNeedDevice(this.needDevice.isSelected());
            ((VoiceAccountType)this.data).setNeedObject(this.needObject.isSelected());
            ((VoiceAccountType)this.data).setStatusConfig(statusJson.toString());
            try {
                ((ClientContext)VoiceAccountTypePanel.this.getContext()).getDirectory(VoiceAccountType.class).update((Id)((VoiceAccountType)this.data));
                VoiceAccountTypePanel.this.performAction("refresh");
                return true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
        }

        private JPanel getGeneralPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.typeTitleTextField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.getSessionPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.entitySpec, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.getChecksPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSessionPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.sessionCountLimit, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)this.sessionCountLimitLock, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            return panel;
        }

        private JPanel getChecksPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.needLogin, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needPassword, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needPhone, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            panel.add((Component)this.needLines, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            panel.add((Component)this.needDevice, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            panel.add((Component)this.needPorts, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            panel.add((Component)this.needObject, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 10, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getStatusPanel() {
            DefaultCellEditor cellEditor = new DefaultCellEditor(this.cellEditorComboBox){
                {
                    this.setClickCountToStart(2);
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    ArrayList<Status> comboBoxList = new ArrayList<Status>();
                    switch (VoiceAccountTypeEditorDialog.this.statusTableModel.getIdentifier(column)) {
                        case "from": 
                        case "to": {
                            comboBoxList.add(new Status(-1, "\u043b\u044e\u0431\u043e\u0439"));
                            comboBoxList.addAll(VoiceAccountTypePanel.this.list);
                            break;
                        }
                        case "if": {
                            comboBoxList.add(new Status(-1, "\u043b\u044e\u0431\u043e\u0439"));
                        }
                        case "set": {
                            comboBoxList.add(new Status(0, "\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
                            comboBoxList.add(new Status(1, "\u0437\u0430\u043a\u0440\u044b\u0442"));
                            comboBoxList.add(new Status(2, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
                            break;
                        }
                    }
                    VoiceAccountTypeEditorDialog.this.cellEditorComboBox.setModel(new DefaultComboBoxModel<Status>(comboBoxList.toArray(new Status[0])));
                    if (VoiceAccountTypeEditorDialog.this.cellEditorComboBox.getModel().getSize() > 0) {
                        VoiceAccountTypeEditorDialog.this.cellEditorComboBox.setSelectedIndex(Utils.parseInt((String)String.valueOf(value)));
                    }
                    return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                }

                @Override
                public Object getCellEditorValue() {
                    return ((Status)VoiceAccountTypeEditorDialog.this.cellEditorComboBox.getSelectedItem()).getId();
                }
            };
            BGUTable table = new BGUTable((TableModel)((Object)this.statusTableModel));
            table.setDefaultEditor(Object.class, (TableCellEditor)cellEditor);
            Dimension dimension = new Dimension(630, 200);
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getStatusTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        private JPanel getStatusTopPanel() {
            JButton addButton = new JButton(ClientUtils.getIcon((String)"add"));
            addButton.addActionListener(e -> {
                this.statusTableModel.getRows().add(new JSONObject("{ \"from\": -1; \"to\": -1; \"if\": -1; \"set\": 0 }"));
                this.statusTableModel.fireTableDataChanged();
            });
            JButton delButton = new JButton(ClientUtils.getIcon((String)"delete"));
            delButton.addActionListener(e -> this.statusTableModel.deleteSelectedRows());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.status, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)addButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            panel.add((Component)delButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        private JPanel getConfigPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane((Component)this.config), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        private void initEntitySpec() {
            try {
                List entitySpecList = ((EntityService)((ClientContext)VoiceAccountTypePanel.this.getContext()).getPort(EntityService.class, 0)).entitySpecList();
                entitySpecList.add(0, new EntitySpec(" --- "));
                this.entitySpec.setData(entitySpecList);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    class StatusTableModel
    extends BGTableModel<JSONObject> {
        public StatusTableModel() {
            super(StatusTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (c)", 150, 150, -1, "from", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (\u043d\u0430)", 150, 150, -1, "to", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 (\u0441)", 150, 150, -1, "if", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 (\u043d\u0430)", 150, 150, -1, "set", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Object getValue(JSONObject val, int column) throws BGException {
            String i;
            switch (i = this.getIdentifier(column)) {
                case "from": 
                case "to": {
                    return this.getContractStatusTitle(val.optInt(i));
                }
                case "if": 
                case "set": {
                    return this.getAccountStatusTitle(val.optInt(i));
                }
            }
            return i;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((JSONObject)this.getRows().get(rowIndex)).put(this.getIdentifier(columnIndex), value);
        }

        private String getAccountStatusTitle(int code) {
            switch (code) {
                case -1: {
                    return "\u043b\u044e\u0431\u043e\u0439";
                }
                case 0: {
                    return "\u0430\u043a\u0442\u0438\u0432\u0435\u043d";
                }
                case 1: {
                    return "\u0437\u0430\u043a\u0440\u044b\u0442";
                }
                case 2: {
                    return "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                }
            }
            return "??? [#" + code + "]";
        }

        private String getContractStatusTitle(int code) {
            for (Status status : VoiceAccountTypePanel.this.list) {
                if (status.getId() != code) continue;
                return status.getTitle().toLowerCase();
            }
            switch (code) {
                case -1: {
                    return "\u043b\u044e\u0431\u043e\u0439";
                }
            }
            return "??? [#" + code + "]";
        }
    }
}

