/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.voice.client.ErrorTableModel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceErrorFilter;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceErrorService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperAccountService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;

public class VoiceErrorPanel
extends BGUPanel {
    BGControlPanelMonthAndDays period = new BGControlPanelMonthAndDays();
    private BGControlPanelPages pagePanel;
    private BGTextField phoneFrom = new BGTextField();
    private BGTextField phoneTo = new BGTextField();
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect();
    BGButtonPanel controlPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.GLUE, BGButtonPanel.DO_M});
    BGTableModel<VoiceError> model = new ErrorTableModel("voiceError");
    BGUComboBox<VoiceDevice> devices = new BGUComboBox();

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.createLeftPanel(), (Component)this.getRightPanel(), 400L), "Center");
    }

    private JPanel getRightPanel() {
        this.pagePanel = new BGControlPanelPages(Utils.getDigest((String)VoiceErrorPanel.class.getName(), (String)"UTF-8"));
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.performAction("show");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(Box.createGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 0, 5, 5), 0, 0));
        final BGUTable tableLog = new BGUTable(this.model);
        tableLog.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && tableLog.isEnabled()) {
                    try {
                        VoiceError error = (VoiceError)VoiceErrorPanel.this.model.getSelectedRow();
                        if (error != null && error.getAccountId() > 0) {
                            VoiceAccount account = ((VoiceAccountService)((ClientContext)VoiceErrorPanel.this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountGet(error.getAccountId());
                            if (account != null) {
                                VoiceErrorPanel.this.openContract(account.getContractId());
                            } else {
                                VoiceOperAccount operAccount = ((VoiceOperAccountService)((ClientContext)VoiceErrorPanel.this.getContext()).getWebService(VoiceOperAccountService.class)).voiceOperAccountGet(error.getAccountId());
                                if (operAccount != null) {
                                    VoiceErrorPanel.this.openContract(operAccount.getContractId());
                                }
                            }
                        }
                    }
                    catch (BGException e1) {
                        VoiceErrorPanel.this.processException(e1);
                    }
                }
            }
        });
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)new JScrollPane((Component)tableLog), "Center");
        panel.add((Component)tablePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel createLeftPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel paramsPanel = this.createParamsPanel();
        JPanel devicePanel = this.createDevicePanel();
        BGSwingUtilites.wrapBorder((JPanel)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434");
        panel.add((Component)this.period, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)devicePanel, (String)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.contractSelect, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)paramsPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.controlPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.controlPanel.addActionListener(l -> {
            this.pagePanel.setPageIndex(1);
            this.performAction("show");
        });
        panel.add(Box.createGlue(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createDevicePanel() {
        JPanel devicePanel = new JPanel(new BorderLayout());
        devicePanel.add((Component)this.devices);
        return devicePanel;
    }

    private JPanel createParamsPanel() {
        JPanel paramsPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)paramsPanel, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        paramsPanel.add((Component)new JLabel("C \u043d\u043e\u043c\u0435\u0440\u0430:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)this.phoneFrom, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("\u041d\u0430 \u043d\u043e\u043c\u0435\u0440:"), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)this.phoneTo, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        return paramsPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "refresh", "refresh", e -> {
            try {
                this.devices.setData(((VoiceDeviceService)((ClientContext)this.getContext()).getWebService(VoiceDeviceService.class)).voiceDeviceSourceList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        new AbstractBGUPanel.DefaultAction("show", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Date dateFrom = TimeUtils.convertLocalDateToDate((LocalDate)VoiceErrorPanel.this.period.getBeginDate());
                Date dateTo = TimeUtils.convertLocalDateToDate((LocalDate)VoiceErrorPanel.this.period.getEndDate().plusDays(1L));
                VoiceDevice device = (VoiceDevice)VoiceErrorPanel.this.devices.getSelectedItem();
                if (device == null) {
                    throw new BGMessageException("\u041d\u0443\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
                }
                VoiceErrorFilter filter = new VoiceErrorFilter();
                filter.setDateFrom(dateFrom);
                filter.setDateTo(dateTo);
                filter.setDeviceIds(Collections.singleton(device.getId()));
                filter.setContractIds(VoiceErrorPanel.this.contractSelect.getContractSet());
                filter.setPhoneFrom(VoiceErrorPanel.this.phoneFrom.getText());
                filter.setPhoneTo(VoiceErrorPanel.this.phoneTo.getText());
                Result result = ((VoiceErrorService)((ClientContext)VoiceErrorPanel.this.getContext()).getWebService(VoiceErrorService.class)).voiceErrorList(filter, VoiceErrorPanel.this.pagePanel.getPage());
                VoiceErrorPanel.this.model.setData(result.getList());
                VoiceErrorPanel.this.pagePanel.setPage(result.getPage());
            }
        };
    }
}

