/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.zonemap;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class VoiceZoneCostMapPanel
extends BGUPanel {
    private VoiceZoneCostMapTableModel tableModel = new VoiceZoneCostMapTableModel();
    private VoiceZoneService voiceZoneService = null;

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.tableModel.setData(this.getVoiceZoneService().voiceZoneCostMapList()));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new VoiceZoneCostMapDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u0446\u0435\u043d \u0437\u043e\u043d", new VoiceZoneCostMap()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.tableModel, VoiceZoneCostMapDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d \u0437\u043e\u043d\u044b"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            VoiceZoneCostMap voiceZoneCostMap = (VoiceZoneCostMap)this.tableModel.getSelectedRow();
            if (voiceZoneCostMap == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (ClientUtils.confirmDelete((Object)voiceZoneCostMap.getTitle())) {
                this.getVoiceZoneService().voiceZoneCostMapDelete(voiceZoneCostMap.getId());
                this.performAction("refresh");
            }
        });
    }

    private VoiceZoneService getVoiceZoneService() {
        if (this.voiceZoneService == null) {
            this.voiceZoneService = (VoiceZoneService)((ClientContext)this.getContext()).getPort(VoiceZoneService.class);
        }
        return this.voiceZoneService;
    }

    class VoiceZoneCostMapTableModel
    extends BGTableModel<VoiceZoneCostMap> {
        public VoiceZoneCostMapTableModel() {
            super(VoiceZoneCostMapTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment").setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class VoiceZoneCostMapDialog
    extends BGEditorDialog<VoiceZoneCostMap> {
        private JTextField title;
        private JTextField comment;
        private VoiceZoneCostMapItemTableModel tableModel;
        private List<VoiceZone> voiceZones;

        public VoiceZoneCostMapDialog(String title, VoiceZoneCostMap data) {
            super(title, (Object)data);
            this.title = new JTextField(70);
            this.comment = new JTextField(70);
            this.tableModel = new VoiceZoneCostMapItemTableModel();
            this.voiceZones = new ArrayList<VoiceZone>();
        }

        public void doDialogPanel() {
            BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
            table.setSelectionMode(0);
            table.setCellEditor((TableCellEditor)new DefaultCellEditor(new JTextField()));
            this.panel.add((Component)this.getTitleCommentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.title.setText(((VoiceZoneCostMap)this.data).getTitle());
            this.comment.setText(((VoiceZoneCostMap)this.data).getComment());
            try {
                this.voiceZones = VoiceZoneCostMapPanel.this.getVoiceZoneService().voiceZoneList();
                if (((VoiceZoneCostMap)this.data).getId() > 0) {
                    this.data = VoiceZoneCostMapPanel.this.getVoiceZoneService().voiceZoneCostMapGet(((VoiceZoneCostMap)this.data).getId());
                }
                this.voiceZones.forEach(a -> {
                    if (!((VoiceZoneCostMap)this.data).getCosts().stream().filter(b -> a.getId() == b.getVoiceZoneId()).findFirst().isPresent()) {
                        VoiceZoneCostMapItem item = new VoiceZoneCostMapItem();
                        item.setVoiceZoneId(a.getId());
                        ((VoiceZoneCostMap)this.data).getCosts().add(item);
                    }
                });
                this.tableModel.setData(((VoiceZoneCostMap)this.data).getCosts());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.title.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            ((VoiceZoneCostMap)this.data).setTitle(this.title.getText());
            ((VoiceZoneCostMap)this.data).setComment(this.comment.getText());
            VoiceZoneCostMapPanel.this.getVoiceZoneService().voiceZoneCostMapUpdate((VoiceZoneCostMap)this.data);
            VoiceZoneCostMapPanel.this.performAction("refresh");
            return super.doApply();
        }

        private JPanel getTitleCommentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        class VoiceZoneCostMapItemTableModel
        extends BGTableModel<VoiceZoneCostMapItem> {
            public VoiceZoneCostMapItemTableModel() {
                super(VoiceZoneCostMapItemTableModel.class.getName());
            }

            protected void initColumns() {
                this.addColumn("\u0417\u043e\u043d\u0430", -1, -1, -1, "voiceZoneId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", BigDecimal.class, 150, 150, 150, "cost", true, true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0437\u0430 \u0441\u0435\u043a.", 150, 150, 150, "costSecond", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            }

            public Object getValue(VoiceZoneCostMapItem val, int column) throws BGException {
                String identifier = this.getIdentifier(column);
                if ("voiceZoneId".equals(identifier)) {
                    return VoiceZoneCostMapDialog.this.voiceZones.stream().filter(a -> a.getId() == val.getVoiceZoneId()).findFirst().map(a -> a.getGuiTitle()).orElse("??? [#" + val.getVoiceZoneId() + "]");
                }
                return super.getValue((Object)val, column);
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex > 0;
            }

            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                String identifier = this.getIdentifier(columnIndex);
                if ("costSecond".equals(identifier)) {
                    if (value instanceof Integer) {
                        Integer sec = (Integer)value;
                        ((VoiceZoneCostMapItem)this.getRows().get(rowIndex)).setCostSecond(sec.intValue());
                        return;
                    }
                } else if ("cost".equals(identifier)) {
                    if (value == null) {
                        ((VoiceZoneCostMapItem)this.getRows().get(rowIndex)).setCost(BigDecimal.ZERO);
                        return;
                    }
                    if (value instanceof BigDecimal) {
                        BigDecimal cost = (BigDecimal)value;
                        ((VoiceZoneCostMapItem)this.getRows().get(rowIndex)).setCost(cost);
                        return;
                    }
                } else {
                    super.setValueAt(value, rowIndex, columnIndex);
                }
            }

            protected void setValue(VoiceZoneCostMapItem e, int column, Object val) {
                super.setValue((Object)e, column, val);
            }
        }
    }
}

