/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.zonemap;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class VoiceZonePanel
extends BGUPanel {
    private BGUTable table;
    private JLabel recordlabel = new JLabel();
    private ZoneTableModel model = new ZoneTableModel();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private VoiceZoneService voiceZoneService = null;

    protected void jbInit() throws Exception {
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(this.getInfoPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
        this.pages.addPropertyChangeListener(e -> this.performAction("refresh"));
    }

    private JPanel getInfoPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordlabel, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private VoiceZoneService getVoiceZoneService() {
        if (this.voiceZoneService == null) {
            this.voiceZoneService = (VoiceZoneService)((ClientContext)this.getContext()).getPort(VoiceZoneService.class);
        }
        return this.voiceZoneService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult searchResult = this.getVoiceZoneService().searchVoiceZone(this.table.getSort(), this.pages.getPage());
            this.pages.setPage(searchResult.getPage());
            this.recordlabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
            this.model.setData(searchResult.getList());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new VoiceZoneDialog("\u041d\u043e\u0432\u0430\u044f \u0437\u043e\u043d\u0430", new VoiceZone()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.model, VoiceZoneDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u043e\u043d\u044b"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            VoiceZone voiceZone = (VoiceZone)this.model.getSelectedRow();
            if (voiceZone == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0437\u043e\u043d\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (ClientUtils.confirmDelete((Object)voiceZone.getTitle())) {
                ((ClientContext)this.getContext()).getDirectory(VoiceZone.class).delete(voiceZone.getId());
                this.performAction("refresh");
            }
        });
    }

    class ZoneTableModel
    extends BGTableModel<VoiceZone> {
        public ZoneTableModel() {
            super(ZoneTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class VoiceZoneDialog
    extends BGEditorDialog<VoiceZone> {
        private JTextField title;

        public VoiceZoneDialog(String title, VoiceZone data) {
            super(title, (Object)data);
            this.title = new JTextField(30);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.title.setText(((VoiceZone)this.data).getTitle());
        }

        public boolean doApply() throws Exception {
            ((VoiceZone)this.data).setTitle(this.title.getText());
            VoiceZonePanel.this.getVoiceZoneService().voiceZoneUpdate((VoiceZone)this.data);
            VoiceZonePanel.this.performAction("refresh");
            return true;
        }
    }
}

