/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.action;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionGetLogAndError
extends bitel.billing.server.call.action.base.ActionGetLogAndError {
    private static Map<String, String> dcMap;

    protected void addData(ResultSet rs, Element parent) throws SQLException {
        String dcColors = this.moduleSetup.get("voip.monitor.dc.color", "");
        HashMap<String, String> colors = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(dcColors, ";");
        while (st.hasMoreTokens()) {
            String[] dc_color = st.nextToken().trim().split(":");
            if (dc_color.length != 2) continue;
            colors.put(dc_color[0], dc_color[1]);
        }
        VoiceUtils vu = new VoiceUtils(this.con, this.mid);
        HashMap<Integer, ParameterMap> nasConfigMap = new HashMap<Integer, ParameterMap>();
        while (rs.next()) {
            int nasId;
            ParameterMap nasConfig;
            Element element = this.createElement(parent, "row");
            element.setAttribute("id", rs.getString("lr"));
            element.setAttribute("cid", rs.getString("t2.id"));
            element.setAttribute("contract", rs.getString("t2.title"));
            element.setAttribute("comment", rs.getString("t2.comment"));
            element.setAttribute("type", rs.getInt("type") == 1 ? "<<" : ">>");
            Timestamp session_start = rs.getTimestamp("session_start");
            element.setAttribute("session_start", TimeUtils.formatFullDate((Date)session_start));
            int time = rs.getInt("session_time");
            element.setAttribute("session_time", Utils.formatSessionTime((int)time));
            float session_cost = rs.getFloat("session_cost");
            element.setAttribute("session_cost", Utils.formatSessionCost((float)session_cost));
            element.setAttribute("from_to", Utils.formatPhoneNumber((String)rs.getString("from_number")) + "/" + Utils.formatPhoneNumber((String)rs.getString("to_number")));
            element.setAttribute("dest", vu.getDestTitle(rs.getInt("t1.dest_code")));
            String dcRawValue = rs.getString("dc");
            String color = (String)colors.get(dcRawValue);
            if (color == null) {
                color = "ffffff";
            }
            if ((nasConfig = (ParameterMap)nasConfigMap.get(nasId = rs.getInt("t1.nas_id"))) == null) {
                String query = "SELECT config FROM nas_config_" + this.mid + " WHERE nas_id=" + nasId;
                try (Statement statement = this.con.createStatement();
                     ResultSet nasRs = statement.executeQuery(query);){
                    if (nasRs.next()) {
                        String config = nasRs.getString("config");
                        nasConfig = new Preferences(config, "\n");
                        nasConfigMap.put(nasId, nasConfig);
                    }
                }
            }
            int dcMode = this.moduleSetup.getInt("voiceip.dc.column.mode", 0);
            Object dcValue = dcRawValue;
            String description = nasConfig.get("voiceip.dc." + dcRawValue, null);
            if (Utils.isBlankString((String)description)) {
                description = dcMap.get(dcRawValue);
            }
            switch (dcMode) {
                case 1: {
                    dcValue = (String)dcValue + " (" + description + ")";
                    break;
                }
                case 2: {
                    dcValue = description;
                }
            }
            element.setAttribute("dc", Integer.parseInt(color, 16) + ";" + (String)dcValue);
        }
    }

    static {
        HashMap<String, String> tmpMap = new HashMap<String, String>(83);
        tmpMap.put("01", "Unallocated or unassigned number");
        tmpMap.put("02", "No route to specified transit network (Transit Network Identity)");
        tmpMap.put("03", "No route to destination");
        tmpMap.put("04", "Send special information tone");
        tmpMap.put("05", "Misdialled trunk prefix");
        tmpMap.put("06", "Channel unacceptable");
        tmpMap.put("07", "Call awarded and being delivered in an established channel");
        tmpMap.put("08", "Prefix 0 dialed but not allowed");
        tmpMap.put("09", "Prefix 1 dialed but not allowed");
        tmpMap.put("0a", "Prefix 1 not dialed but required");
        tmpMap.put("0b", "More digits received than allowed, call is proceeding");
        tmpMap.put("10", "Normal call clearing");
        tmpMap.put("11", "User busy");
        tmpMap.put("12", "No user responding");
        tmpMap.put("13", "T.301 expired: \u2013 User Alerted, No answer from user");
        tmpMap.put("15", "Call rejected");
        tmpMap.put("16", "Number changed to number in diagnostic field.");
        tmpMap.put("17", "Reverse charging rejected");
        tmpMap.put("18", "Call suspended");
        tmpMap.put("19", "Call resumed");
        tmpMap.put("1a", "Non-selected user clearing");
        tmpMap.put("1b", "Destination out of order");
        tmpMap.put("1c", "Invalid number format or incomplete address");
        tmpMap.put("1d", "EKTS facility rejected by network");
        tmpMap.put("1e", "Response to STATUS ENQUIRY");
        tmpMap.put("1f", "Normal, unspecified");
        tmpMap.put("21", "Circuit out of order");
        tmpMap.put("22", "No circuit/channel available");
        tmpMap.put("23", "Destination unattainable");
        tmpMap.put("24", "Out of order");
        tmpMap.put("25", "Degraded service");
        tmpMap.put("26", "Network out of order");
        tmpMap.put("27", "Transit delay range cannot be achieved");
        tmpMap.put("28", "Throughput range cannot be achieved");
        tmpMap.put("29", "Temporary failure");
        tmpMap.put("2a", "Switching equipment congestion");
        tmpMap.put("2b", "Access information discarded");
        tmpMap.put("2c", "Requested circuit channel not available");
        tmpMap.put("2d", "Preempted");
        tmpMap.put("2e", "Precedence call blocked");
        tmpMap.put("2f", "Resource unavailable, unspecified");
        tmpMap.put("31", "Quality of service unavailable");
        tmpMap.put("32", "Requested facility not subscribed");
        tmpMap.put("33", "Reverse charging not allowed");
        tmpMap.put("34", "Outgoing calls barred");
        tmpMap.put("35", "Outgoing calls barred within CUG");
        tmpMap.put("36", "Incoming calls barred");
        tmpMap.put("37", "Incoming calls barred within CUG");
        tmpMap.put("38", "Call waiting not subscribed");
        tmpMap.put("39", "Bearer capability not authorized");
        tmpMap.put("3a", "Bearer capability not presently available");
        tmpMap.put("3f", "Service or option not available, unspecified");
        tmpMap.put("41", "Bearer service not implemented");
        tmpMap.put("42", "Channel type not implemented");
        tmpMap.put("43", "Transit network selection not implemented");
        tmpMap.put("44", "Message not implemented");
        tmpMap.put("45", "Requested facility not implemented");
        tmpMap.put("46", "Only restricted digital information bearer capability is available");
        tmpMap.put("4f", "Service or option not implemented, unspecified");
        tmpMap.put("51", "Invalid call reference value");
        tmpMap.put("52", "Identified channel does not exist");
        tmpMap.put("53", "A suspended call exists, but this call identity does not");
        tmpMap.put("54", "Call identity in use");
        tmpMap.put("55", "No call suspended");
        tmpMap.put("56", "Call having the requested call identity has been cleared");
        tmpMap.put("57", "Called user not member of CUG");
        tmpMap.put("58", "Incompatible destination");
        tmpMap.put("59", "Non-existent abbreviated address entry");
        tmpMap.put("5a", "Destination address missing, and direct call not subscribed");
        tmpMap.put("5b", "Invalid transit network selection (national use)");
        tmpMap.put("5c", "Invalid facility parameter 93 Mandatory information element is missing");
        tmpMap.put("5d", "Message type non-existent or not implemented");
        tmpMap.put("5f", "Invalid message, unspecified");
        tmpMap.put("60", "Mandatory information element is missing");
        tmpMap.put("61", "Message type non-existent or not implemented");
        tmpMap.put("62", "Message not compatible with call state or message type non-existent or not implemented");
        tmpMap.put("63", "Information element nonexistent or not implemented");
        tmpMap.put("64", "Invalid information element contents");
        tmpMap.put("65", "Message not compatible with call state");
        tmpMap.put("66", "Recovery on timer expiry");
        tmpMap.put("67", "Parameter non-existent or not implemented \u2013 passed on");
        tmpMap.put("6f", "Protocol error, unspecified");
        tmpMap.put("7f", "Internetworking, unspecified");
        dcMap = Collections.unmodifiableMap(tmpMap);
    }
}

