/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotManagement;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.VKRuntimeBot;
import ru.bitel.common.Utils;

@WebServlet(name="vkBotCallback", urlPatterns={"/vkBotCallback/*"})
public class VKBotCallback
extends CommonExecutor {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!req.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String pathInfo = req.getPathInfo();
        String[] params = pathInfo.split("/");
        int botId = Utils.parseInt((String)params[1], (int)-1);
        ServerContext serverContext = (ServerContext)ServerContext.get();
        RuntimeBot runtimeBot = BotManagement.getOrInitAndGet(serverContext, this.getMid(req)).getBot(botId);
        if (runtimeBot == null) {
            this.getLogger().error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c botId \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            resp.setStatus(500);
            return;
        }
        if (runtimeBot.getBotState() == 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041f\u0440\u0438\u0448\u043b\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0431\u043e\u0442\u0430");
            }
            resp.setStatus(500);
            return;
        }
        String body = IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8");
        resp.setContentType("text/html;charset=utf-8");
        resp.setStatus(200);
        resp.getWriter().println("OK");
        JSONObject jsonBody = new JSONObject(body);
        if (!"message_new".equals(jsonBody.optString("type"))) {
            return;
        }
        int groupId = jsonBody.optInt("group_id", -1);
        if (groupId < 0) {
            this.getLogger().error("group_id in request < 0");
            return;
        }
        JSONObject innerObj = jsonBody.optJSONObject("object");
        String messageText = innerObj.optString("body");
        int fromId = innerObj.optInt("user_id", -1);
        try {
            ((VKRuntimeBot)runtimeBot).getApiHandler().messageNew(groupId, fromId, messageText);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private int getMid(HttpServletRequest request) {
        try {
            return CommonExecutor.getModuleId((HttpServletRequest)request);
        }
        catch (BGMessageException e) {
            return -1;
        }
    }
}

