/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.export.ExportAbstractUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ExportBillUtils
extends ExportAbstractUtils {
    public ExportBillUtils(Connection con, int moduleId) {
        super(con, moduleId);
        this.csvSeparator = this.moduleSetup.get("csv.separator", ",").toCharArray()[0];
        this.saveOnServerPath = this.moduleSetup.get("preempt.bill.reestr.to.server.path", null);
    }

    public String doExport(BillListFilter billListFilter, boolean saveOnServer) throws Exception {
        BillManager billManager = new BillManager(this.con, this.moduleId);
        ArrayList<String[]> allLines = new ArrayList<String[]>();
        StringBuilder sb = new StringBuilder();
        Writer writer = null;
        if (saveOnServer) {
            File file = new File(this.saveOnServerPath);
            writer = new OutputStreamWriter(new FileOutputStream(file));
        } else {
            writer = new StringWriter();
        }
        String preemptXSL = this.moduleSetup.get("preempt.bill.reestr.over.xsl", null);
        if (Utils.notBlankString((String)preemptXSL)) {
            if (preemptXSL.equals("true")) {
                preemptXSL = "bill_preempt_bill_reestr.xsl";
            }
            billListFilter.setGetXml(true);
            int pageCount = (int)Math.ceil((double)billListFilter.getCountOfBill() / 10.0);
            for (int i = 1; i <= pageCount; ++i) {
                billListFilter.getPage().setPageIndex(i);
                billListFilter.getPage().setPageSize(10);
                List<Bill> payBillList = billManager.getBillList(billListFilter, billListFilter.isGetXml(), billListFilter.isForRegister());
                this.preemptBillNew(payBillList, preemptXSL, saveOnServer, writer, sb);
            }
        } else {
            List<Bill> payBillList = billManager.getBillList(billListFilter, billListFilter.isGetXml(), billListFilter.isForRegister());
            for (Bill bill : payBillList) {
                String[] line = new String[10];
                line[0] = bill.getContractTitle();
                line[1] = Utils.maskNull((String)bill.getRecipient());
                line[2] = Utils.maskNull((String)bill.getAddress());
                line[3] = Utils.maskNull((String)bill.getTypeTitle());
                line[4] = bill.getFormatNumber();
                line[5] = TimeUtils.formatDate((Date)bill.getCreateDate());
                line[6] = Utils.formatBigDecimalSumm((BigDecimal)bill.getSum());
                allLines.add(line);
            }
            this.preemptBillOld(allLines, saveOnServer, writer, sb);
        }
        return sb.toString();
    }
}

