/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.utils;

import bitel.billing.server.admin.bean.AddressManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerBankInfo;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class SormUploadHelper {
    private final Preferences config;
    private SormContract currentContract;
    private int currentContractId;
    private final int billMid;
    private final Connection connection;
    private final ContractDao contractDao;
    private final AddressManager addressManager;
    private int superContractId;
    private JSONObject customer;
    private final Map<Integer, JSONObject> contractCustomerMap;

    public SormUploadHelper(Preferences config, Connection connection, AddressManager addressManager, List<Integer> contractIds) throws BGException {
        this.config = config;
        this.connection = connection;
        this.contractDao = new ContractDao(connection, 0);
        this.addressManager = addressManager;
        this.billMid = this.getIntFromConfig("sorm.bill.mid");
        try {
            this.contractCustomerMap = new CustomerDao(connection).getCustomerDataListForContracts(contractIds);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setCurrentContract(SormContract sormContract) throws Exception {
        this.currentContract = sormContract;
        this.currentContractId = sormContract.getContractId();
        this.superContractId = sormContract.isSub() ? this.currentContract.getScid() : -1;
        JSONObject jSONObject = this.customer = this.contractCustomerMap.containsKey(this.currentContractId) ? this.contractCustomerMap.get(this.currentContractId) : this.contractCustomerMap.get(this.superContractId);
        if (this.customer == null) {
            this.customer = new JSONObject();
        }
    }

    public void setCurrentContract(Contract contract) throws Exception {
        this.setCurrentContract(this.convertContractToSormContract(contract));
    }

    public SormContract convertContractToSormContract(Contract newContract) {
        return new SormContract(newContract.getId(), newContract.getTitle(), newContract.getDateFrom(), newContract.getDateTo(), newContract.getPersonType() == 0, newContract.getStatus(), newContract.isSub(), newContract.getSuperContractId());
    }

    public String getCustomerValueByQuery(String jsonQuery) {
        return Optional.ofNullable(this.customer.optQuery(jsonQuery)).map(Object::toString).orElse("");
    }

    public String getFirstName() throws BGException {
        String firstName = this.getStringParam("sorm.upload.fiz.firstname");
        if (Utils.isBlankString((String)firstName)) {
            firstName = this.getCustomerValueByQuery(Customer.Keys.FIRST_NAME.key());
        }
        return firstName;
    }

    public String getLastName() throws BGException {
        String lastName = this.getStringParam("sorm.upload.fiz.lastname");
        if (Utils.isBlankString((String)lastName)) {
            lastName = this.getCustomerValueByQuery(Customer.Keys.LAST_NAME.key());
        }
        return lastName;
    }

    public String getMiddleName() throws BGException {
        String midlleName = this.getStringParam("sorm.upload.fiz.middlename");
        if (Utils.isBlankString((String)midlleName)) {
            midlleName = this.getCustomerValueByQuery(Customer.Keys.MIDDLE_NAME.key());
        }
        return midlleName;
    }

    public String getDocumentSerial() throws BGException {
        String documentSerial = this.getStringParam("sorm.upload.fiz.documentserial");
        if (Utils.isBlankString((String)documentSerial)) {
            documentSerial = this.getCustomerValueByQuery(Customer.CustomerFizDocument.PASSPORT_RF_SERIAL.key());
        }
        return documentSerial;
    }

    public String getDocumentNumber() throws BGException {
        String documentNumber = this.getStringParam("sorm.upload.fiz.documentnumber");
        if (Utils.isBlankString((String)documentNumber)) {
            documentNumber = this.getCustomerValueByQuery(Customer.CustomerFizDocument.PASSPORT_RF_NUMBER.key());
        }
        return documentNumber;
    }

    public String getDocumentWhoGive() throws BGException {
        String documentWhoGive = this.getStringParam("sorm.upload.fiz.documentwhogive");
        if (Utils.isBlankString((String)documentWhoGive)) {
            documentWhoGive = this.getCustomerValueByQuery(Customer.CustomerFizDocument.PASSPORT_RF_WHO_GIVE.key());
        }
        return documentWhoGive;
    }

    public String getDocumentWhenGive(String format) {
        String whenGive = this.getDateParam("sorm.upload.fiz.documentwhengive", format);
        if (Utils.isBlankString((String)whenGive) && Utils.notBlankString((String)(whenGive = this.getCustomerValueByQuery(Customer.CustomerFizDocument.PASSPORT_RF_WHEN_GIVE.key())))) {
            whenGive = TimeUtils.format((LocalDate)LocalDate.parse(whenGive), (String)"dd.MM.yyyy");
        }
        return whenGive;
    }

    public String getBirthday(String format) {
        String birthday = this.getDateParam("sorm.upload.fiz.birthday", format);
        if (Utils.isBlankString((String)birthday) && Utils.notBlankString((String)(birthday = this.getCustomerValueByQuery(Customer.Keys.BIRTHDAY.key())))) {
            Date date = TimeUtils.parseDate((String)(birthday + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            birthday = TimeUtils.format((Date)date, (String)format);
        }
        return birthday;
    }

    public String getStringParam(String configKey) throws BGException {
        return this.getStringParam(this.getIntFromConfig(configKey), true);
    }

    public String getStringParam(String configKey, boolean checkSuperContract) throws BGException {
        return this.getStringParam(this.getIntFromConfig(configKey), checkSuperContract);
    }

    public String getStringParam(int parameterId, boolean checkSuperContract) throws BGException {
        String result = this.contractDao.optContractParameterTextAsString(this.currentContractId, parameterId).orElse(null);
        if (Utils.isBlankString((String)result) && this.currentContract.isSub() && checkSuperContract) {
            result = this.contractDao.optContractParameterTextAsString(this.superContractId, parameterId).orElse(null);
        }
        if (Utils.isBlankString((String)result)) {
            return "";
        }
        return result.trim();
    }

    public String getEmail(boolean isFiz) throws BGException {
        String result = "";
        List<String> emails = this.getEmails(isFiz);
        if (Utils.notEmptyCollection(emails)) {
            result = emails.get(0);
        }
        return result;
    }

    public List<String> getEmails(boolean isFiz) throws BGException {
        int emailPid = Utils.parseInt((String)(isFiz ? this.config.get("sorm.upload.fiz.email") : this.config.get("sorm.upload.org.email")), (int)-1);
        if (emailPid < 0) {
            return Collections.emptyList();
        }
        Optional email = this.contractDao.getContractParameterEmail(this.currentContractId, emailPid);
        if (email.isEmpty() && this.superContractId > 0) {
            email = this.contractDao.getContractParameterEmail(this.superContractId, emailPid);
        }
        if (email.isPresent() && Utils.notEmptyCollection((Collection)((EntityAttrEmail)email.get()).getAddressList())) {
            return ((EntityAttrEmail)email.get()).getAddressList();
        }
        return Collections.emptyList();
    }

    public String getDateParam(String configKey) {
        return this.getDateParam(configKey, null);
    }

    public String getDateParam(String configKey, String format) {
        try {
            Date date;
            EntityAttrDate attrDate = (EntityAttrDate)this.contractDao.getContractParameter(this.currentContractId, this.getIntFromConfig(configKey));
            Date date2 = date = attrDate != null ? attrDate.getValue() : null;
            if (date == null && this.currentContract.isSub()) {
                attrDate = (EntityAttrDate)this.contractDao.getContractParameter(this.superContractId, this.getIntFromConfig(configKey));
                Date date3 = date = attrDate != null ? attrDate.getValue() : null;
            }
            if (date == null) {
                return "";
            }
            return Utils.isBlankString((String)format) ? TimeUtils.formatFullDate((Date)date) : TimeUtils.format((Date)date, (String)format);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private int getIntFromConfig(String configKey) {
        return this.config.getInt(configKey, -1);
    }

    public String getBankTitle() throws BGException {
        List bankInfos;
        String bankTitle = this.getStringParam("sorm.upload.org.banktitle");
        if (Utils.isBlankString((String)bankTitle)) {
            bankTitle = this.getAttributeFromBill("sorm.bill.attr.banktitle");
        }
        if (Utils.isBlankString((String)bankTitle) && !this.currentContract.isFiz() && Utils.notEmptyCollection((Collection)(bankInfos = CustomerBankInfo.forCustomer((JSONObject)this.customer)))) {
            bankTitle = ((CustomerBankInfo)bankInfos.getFirst()).getName();
        }
        return Utils.maskBlank((String)bankTitle, (String)"").trim();
    }

    public String getBankAccount() throws BGException {
        List bankInfos;
        String bankAccount = this.getStringParam("sorm.upload.org.account");
        if (Utils.isBlankString((String)bankAccount)) {
            bankAccount = this.getAttributeFromBill("sorm.bill.attr.account");
        }
        if (Utils.isBlankString((String)bankAccount)) {
            bankAccount = this.getCustomerValueByQuery(Customer.Keys.BANK_ACCOUNT.key());
        }
        if (Utils.isBlankString((String)bankAccount) && Utils.notEmptyCollection((Collection)(bankInfos = CustomerBankInfo.forCustomer((JSONObject)this.customer)))) {
            bankAccount = ((CustomerBankInfo)bankInfos.getFirst()).getAccountR();
        }
        return Utils.maskBlank((String)bankAccount, (String)"").trim();
    }

    public String getFullTitleOrg() throws BGException {
        String fullTitle = this.getStringParam("sorm.upload.org.fulltitle");
        if (Utils.isBlankString((String)fullTitle)) {
            fullTitle = this.getAttributeFromBill("sorm.bill.attr.fulltitle");
        }
        if (Utils.isBlankString((String)fullTitle)) {
            fullTitle = this.getCustomerValueByQuery(Customer.Keys.NAME.key());
        }
        return Utils.maskBlank((String)fullTitle, (String)"").trim();
    }

    public String getINN() throws BGException {
        String inn = this.getStringParam("sorm.upload.org.inn");
        if (Utils.isBlankString((String)inn)) {
            inn = this.getAttributeFromBill("sorm.bill.attr.inn");
        }
        if (Utils.isBlankString((String)inn)) {
            inn = this.getCustomerValueByQuery(Customer.Keys.INN.key());
        }
        return Utils.maskBlank((String)inn, (String)"").trim();
    }

    public String getBIK() throws BGException {
        String bik = this.getStringParam("sorm.upload.org.bankbik");
        if (Utils.isBlankString((String)bik)) {
            this.getAttributeFromBill("sorm.bill.attr.bik");
        }
        if (Utils.isBlankString((String)bik)) {
            bik = this.getCustomerValueByQuery(Customer.Keys.BANK_BIK.key());
        }
        return Utils.maskBlank((String)bik, (String)"").trim();
    }

    public String getPhoneParam(String configKey) throws BGException {
        int phonePid = this.getIntFromConfig(configKey);
        if (phonePid < 0) {
            return "";
        }
        EntityAttr attrPhone = this.contractDao.getContractParameter(this.currentContractId, phonePid);
        if (attrPhone == null && this.currentContract.isSub()) {
            attrPhone = this.contractDao.getContractParameter(this.superContractId, phonePid);
        }
        if (attrPhone == null) {
            return "";
        }
        String phoneNumber = "";
        if (attrPhone instanceof EntityAttrPhone) {
            EntityAttrPhone phoneParameter = (EntityAttrPhone)attrPhone;
            phoneNumber = phoneParameter.getContactList().isEmpty() ? "" : ((EntityAttrPhone.PhoneContact)phoneParameter.getContactList().get(0)).getPhone();
        } else if (attrPhone instanceof EntityAttrText) {
            EntityAttrText phoneParameter = (EntityAttrText)attrPhone;
            phoneNumber = phoneParameter.getValue();
        }
        Object resultNumber = Pattern.compile("[^\\d\\s]+").matcher(Utils.maskBlank((String)phoneNumber, (String)"")).replaceAll("").replaceAll("\\s", "");
        if (((String)resultNumber).startsWith("8")) {
            resultNumber = "7" + ((String)resultNumber).substring(1);
        }
        return resultNumber;
    }

    public String getContactFacePhone() throws BGException {
        List phones;
        String phone = this.getStringParam("sorm.upload.org.contactfacenumber");
        int phoneParameterId = this.getIntFromConfig("sorm.upload.org.contactfacenumber");
        if (Utils.isBlankString((String)phone)) {
            phones = this.contractDao.getContractParameterPhone(this.currentContractId, phoneParameterId).map(EntityAttrPhone::toUnformattedPhoneList).orElse(null);
            String string = phone = phones == null || phones.isEmpty() ? "" : (String)phones.get(0);
        }
        if (Utils.isBlankString((String)phone)) {
            phones = this.contractDao.getContractParameterPhone(this.superContractId, phoneParameterId).map(EntityAttrPhone::toUnformattedPhoneList).orElse(null);
            phone = phones == null || phones.isEmpty() ? "" : (String)phones.get(0);
        }
        return Utils.maskBlank((String)phone, (String)"").trim().replaceAll("\\+", "");
    }

    public AddressStruct getAddressByPid(int pid) {
        AddressStruct address = this.addressManager.getAddress(this.currentContractId, pid);
        if (!SormUtils.checkValidAddress(address) && this.currentContract.isSub()) {
            address = this.addressManager.getAddress(this.superContractId, pid);
        }
        if (!SormUtils.checkValidAddress(address)) {
            return null;
        }
        return address;
    }

    public AddressStruct getAddress() {
        int addressPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.address") : this.getIntFromConfig("sorm.upload.org.address");
        return this.getAddressByPid(addressPid);
    }

    public String getUnstructAddress() throws BGException {
        int addressUnstructPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.unstructaddress") : this.getIntFromConfig("sorm.upload.org.unstructaddress");
        String unstructAddress = this.getStringParam(addressUnstructPid, false);
        if (Utils.isBlankString((String)unstructAddress)) {
            unstructAddress = this.getCustomerValueByQuery(this.currentContract.isFiz() ? Customer.CustomerFizDocument.PASSPORT_RF_ADDRESS.key() : Customer.Keys.U_ADDRESS.key());
        }
        if (Utils.isBlankString((String)unstructAddress) && this.currentContract.isSub()) {
            unstructAddress = this.getStringParam(addressUnstructPid, true);
        }
        if (Utils.isBlankString((String)unstructAddress)) {
            unstructAddress = this.getUserAddressValueFromAddressParameter(this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.address") : this.getIntFromConfig("sorm.upload.org.address"));
        }
        return Utils.maskBlank((String)unstructAddress, (String)"");
    }

    private String getUserAddressValueFromAddressParameter(int addressPid) {
        AddressStruct address = this.addressManager.getAddress(this.currentContractId, addressPid);
        if (SormUtils.checkValidAddress(address)) {
            return "";
        }
        return address != null ? address.getFullAddress() : "";
    }

    public AddressStruct getCommutatorsAddress() {
        int addressPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.addressinstallcommutator") : this.getIntFromConfig("sorm.upload.org.addresscommutators");
        return this.getAddressByPid(addressPid);
    }

    public String getUnstructCommutatorsAddress() throws BGException {
        int unstructAddressPid = this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.unstructaddressinstallcommutator") : this.getIntFromConfig("sorm.upload.org.addresscommutatorsunstruct");
        String unstructCommutatorAddress = this.getStringParam(unstructAddressPid, true);
        if (Utils.isBlankString((String)unstructCommutatorAddress)) {
            unstructCommutatorAddress = this.getUserAddressValueFromAddressParameter(this.currentContract.isFiz() ? this.getIntFromConfig("sorm.upload.fiz.addressinstallcommutator") : this.getIntFromConfig("sorm.upload.org.addresscommutators"));
        }
        return unstructCommutatorAddress;
    }

    public AddressStruct getAddressBills() {
        return this.getAddressByPid(this.currentContract.isFiz() ? -1 : this.getIntFromConfig("sorm.upload.org.addressbills"));
    }

    public String getUnstructAddressBills() throws BGException {
        int addressUnstructPid = this.currentContract.isFiz() ? -1 : this.getIntFromConfig("sorm.upload.org.addressbillsunstruct");
        String unstructAddressBills = this.getStringParam(addressUnstructPid, true);
        if (Utils.isBlankString((String)unstructAddressBills)) {
            unstructAddressBills = this.getUserAddressValueFromAddressParameter(this.currentContract.isFiz() ? -1 : this.getIntFromConfig("sorm.upload.org.addressbills"));
        }
        return unstructAddressBills;
    }

    public String getAttributeFromBill(String attributeName) throws BGException {
        String result = this.getAttributeFromBill(attributeName, this.currentContractId);
        if (Utils.isBlankString((String)result) && this.currentContract.isSub()) {
            result = this.getAttributeFromBill(attributeName, this.superContractId);
        }
        return result;
    }

    public String getAttributeFromBill(String attributeName, int contractId) throws BGException {
        String attr = this.config.get(attributeName, "");
        if (Utils.isBlankString((String)attr)) {
            return "";
        }
        String result = "";
        String tableName = ServerUtils.getModuleTableName((String)"bill_attribute", (int)this.billMid);
        if (ServerUtils.tableExists((Connection)this.connection, (String)tableName)) {
            String query = "SELECT value FROM " + tableName + " WHERE name=? AND cid=?";
            try (PreparedStatement ps = this.connection.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, attr);
                ps.setInt(index, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = rs.getString("value");
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    public boolean contractIsActive() {
        Date contractDateTo = this.currentContract.getDateTo();
        if (contractDateTo == null) {
            return true;
        }
        return contractDateTo.after(new Date());
    }

    public SormContract getCurrentContract() {
        return this.currentContract;
    }
}

