/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDate;
import org.json.JSONObject;
import ru.bitel.common.Utils;
import ru.bitel.common.xml.XmlAdapters;

public class CustomerEmployee {
    private int customerId;
    private String uuid;
    private String position;
    private String fio;
    private String phone;
    private String mobile;
    private String email;
    private String comment;
    private LocalDate birthday;
    private String address;
    private String documentSerial;
    private String documentNumber;
    private String documentWhoGive;
    private LocalDate documentWhenGive;
    private LocalDate dateFrom;
    private LocalDate dateTo;

    @XmlAttribute
    public int getCustomerId() {
        return this.customerId;
    }

    @XmlAttribute
    public String getUuid() {
        return this.uuid;
    }

    @XmlAttribute
    public String getPosition() {
        return this.position;
    }

    @XmlAttribute
    public String getFio() {
        return this.fio;
    }

    @XmlAttribute
    public String getPhone() {
        return this.phone;
    }

    @XmlAttribute
    public String getMobile() {
        return this.mobile;
    }

    @XmlAttribute
    public String getEmail() {
        return this.email;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    public CustomerEmployee setCustomerId(int customerId) {
        this.customerId = customerId;
        return this;
    }

    public CustomerEmployee setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public CustomerEmployee setPosition(String position) {
        this.position = position;
        return this;
    }

    public CustomerEmployee setFio(String fio) {
        this.fio = fio;
        return this;
    }

    public CustomerEmployee setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public CustomerEmployee setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public CustomerEmployee setEmail(String email) {
        this.email = email;
        return this;
    }

    public CustomerEmployee setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public CustomerEmployee setBirthday(LocalDate birthday) {
        this.birthday = birthday;
        return this;
    }

    @XmlJavaTypeAdapter(value=XmlAdapters.LocalDateAdapter.class)
    public LocalDate getBirthday() {
        return this.birthday;
    }

    @XmlAttribute
    public String getAddress() {
        return this.address;
    }

    public CustomerEmployee setAddress(String address) {
        this.address = address;
        return this;
    }

    @XmlAttribute
    public String getDocumentSerial() {
        return this.documentSerial;
    }

    public CustomerEmployee setDocumentSerial(String documentSerial) {
        this.documentSerial = documentSerial;
        return this;
    }

    @XmlAttribute
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public CustomerEmployee setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    @XmlAttribute
    public String getDocumentWhoGive() {
        return this.documentWhoGive;
    }

    public CustomerEmployee setDocumentWhoGive(String documentWhoGive) {
        this.documentWhoGive = documentWhoGive;
        return this;
    }

    @XmlJavaTypeAdapter(value=XmlAdapters.LocalDateAdapter.class)
    public LocalDate getDocumentWhenGive() {
        return this.documentWhenGive;
    }

    public CustomerEmployee setDocumentWhenGive(LocalDate documentWhenGive) {
        this.documentWhenGive = documentWhenGive;
        return this;
    }

    @XmlJavaTypeAdapter(value=XmlAdapters.LocalDateAdapter.class)
    public LocalDate getDateFrom() {
        return this.dateFrom;
    }

    public CustomerEmployee setDateFrom(LocalDate dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    @XmlJavaTypeAdapter(value=XmlAdapters.LocalDateAdapter.class)
    public LocalDate getDateTo() {
        return this.dateTo;
    }

    public CustomerEmployee setDateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public static CustomerEmployee fromJSON(JSONObject jsonObject) {
        return new CustomerEmployee().setUuid(jsonObject.optString("uuid")).setPosition(jsonObject.optString("post")).setFio(jsonObject.optString("fio")).setPhone(jsonObject.optString("phone")).setMobile(jsonObject.optString("mobile")).setEmail(jsonObject.optString("email")).setComment(jsonObject.optString("comment")).setBirthday(Utils.notBlankString(jsonObject.optString("birthday")) ? LocalDate.parse(jsonObject.optString("birthday")) : null).setAddress(jsonObject.optString("address")).setDocumentSerial(jsonObject.optString("documentSerial")).setDocumentNumber(jsonObject.optString("documentNumber")).setDocumentWhoGive(jsonObject.optString("documentWhoGive")).setDocumentWhenGive(Utils.notBlankString(jsonObject.optString("documentWhenGive")) ? LocalDate.parse(jsonObject.optString("documentWhenGive")) : null).setDateFrom(Utils.notBlankString(jsonObject.optString("dateFrom")) ? LocalDate.parse(jsonObject.optString("dateFrom")) : null).setDateTo(Utils.notBlankString(jsonObject.optString("dateTo")) ? LocalDate.parse(jsonObject.optString("dateTo")) : null);
    }

    public JSONObject toJSON() {
        return new JSONObject().put("uuid", (Object)this.uuid).put("post", (Object)this.position).put("fio", (Object)this.fio).put("phone", (Object)this.phone).put("mobile", (Object)this.mobile).put("email", (Object)this.email).put("comment", (Object)this.comment).put("birthday", (Object)(this.birthday == null ? "" : this.birthday.toString())).put("address", (Object)this.address).put("documentSerial", (Object)this.documentSerial).put("documentNumber", (Object)this.documentNumber).put("documentWhoGive", (Object)this.documentWhoGive).put("documentWhenGive", (Object)(this.documentWhenGive == null ? "" : this.documentWhenGive.toString())).put("dateFrom", (Object)(this.dateFrom == null ? "" : this.dateFrom.toString())).put("dateTo", (Object)(this.dateTo == null ? "" : this.dateTo.toString()));
    }
}

