/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SubscriptionDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="dispatchexecutor", urlPatterns={"/dispatchexecutor/*"})
public class DispatchExecutor
extends CommonExecutor {
    private BGPluginServer plugin;

    public void init() throws ServletException {
        super.init();
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String queryString = req.getQueryString();
        String[] parameters = queryString.split(";");
        HashMap<String, String> parametersMap = new HashMap<String, String>(parameters.length);
        for (String paramWithValue : parameters) {
            parametersMap.put(paramWithValue.split("=")[0], paramWithValue.split("=")[1]);
        }
        int contractId = Utils.parseInt((String)((String)parametersMap.get("contractId")));
        if (contractId > 0) {
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                String hashString = (String)parametersMap.get("subscriberId");
                SubscriptionDao subscriptionDao = new SubscriptionDao(con);
                Subscription subscription = subscriptionDao.getByHash(hashString);
                if (subscription != null && subscription.getContractId() == contractId) {
                    String redirectUrl;
                    subscription = subscriptionDao.deleteByHash(hashString);
                    if (subscription.getContacts().size() <= 0) {
                        subscriptionDao.delete(subscription.getId());
                    }
                    if (Utils.notBlankString((String)(redirectUrl = this.plugin.getSetup().get("dispatch.after.unsubscribe.url")))) {
                        resp.sendRedirect(redirectUrl);
                    } else {
                        resp.setContentType("text/html; charset=utf-8");
                        resp.setStatus(200);
                        resp.getWriter().println("<p>\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0438\u0441\u0430\u043b\u0438\u0441\u044c \u043e\u0442 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438!</p>");
                    }
                } else {
                    resp.setContentType("text/html; charset=utf-8");
                    resp.setStatus(400);
                    resp.getWriter().println("<p>\u0422\u0430\u043a\u043e\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043e\u043d\u0430 \u0431\u044b\u043b\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430!</p>");
                }
            }
            catch (SQLException e) {
                this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0411\u0414!", (Throwable)e);
                resp.setStatus(500);
            }
        }
    }
}

