/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.notification.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.notification.common.bean.ContractNotification;
import ru.bitel.bgbilling.plugins.notification.common.service.ContractNotificationService;
import ru.bitel.bgbilling.plugins.notification.server.bean.ContractNotificationDao;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.notification.common.service.ContractNotificationService")
public class ContractNotificationServiceImpl
extends AbstractService
implements ContractNotificationService {
    private ContractNotificationDao contractNotificationDao;

    @PostConstruct
    void init() {
        this.contractNotificationDao = new ContractNotificationDao(this.getConnection());
    }

    public List<ContractNotification> contractNotificationList(int contractId) throws BGException {
        return (List)this.tryReturn(() -> this.contractNotificationDao.list(contractId));
    }

    public void contractNotificationDelete(int contractId, int id) throws BGException {
        this.tryCall(() -> {
            ContractNotification cn = (ContractNotification)this.contractNotificationDao.get(id);
            if (cn == null || cn.getContractId() != contractId) {
                throw new BGIllegalArgumentException();
            }
            this.contractNotificationDao.delete(id);
        });
    }

    public int contractNotificationUpdate(int contractId, ContractNotification contractNotification) throws BGException {
        if (contractNotification == null) {
            throw new BGIllegalArgumentException("contractNotification");
        }
        if (contractNotification.getContractId() <= 0 || contractNotification.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        return (Integer)this.tryReturn(() -> {
            this.contractNotificationDao.update(contractNotification);
            return contractNotification.getId();
        });
    }

    public void contractNotificationMarkRead(int contractId, int id) throws BGException {
        this.tryCall(() -> this.contractNotificationDao.markReadNotification(contractId, id));
    }

    public int contractNotificationUnreadCount(int contractId) throws BGException {
        return (Integer)this.tryReturn(() -> this.contractNotificationDao.getUnreadNotificationsCount(contractId));
    }
}

