/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.action.web;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebApiManager;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebTariffDAO;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

public class ActionGetUrl
extends AbstractAction {
    private DrwebAgentDAO drwebAgentDAO;
    private DrwebApiManager drwebApiManager;

    public ActionGetUrl() {
        super("drwebn");
    }

    public void execute() throws BGException {
        int step = this.req.getInt("step", 0);
        int tariffId = this.req.getInt("tariff", -1);
        Result result = new Result(new ArrayList());
        try {
            result.setList(this.getDrwebAgentDAO().getAgentListByCid(this.contractId));
            if (step == 1) {
                this.getDrwebApiManager().checkMaxAgentCount(this.contractId);
                DrwebAgent agent = this.getDrwebApiManager().newAgent(this.contractId, tariffId);
                result.setAttribute("agent", (Object)agent);
                result.setAttribute("step", (Object)"1");
            } else {
                result.setAttribute("step", (Object)"0");
                result.setAttribute("tariffs", this.getTariffs(true));
            }
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
        }
    }

    public Result<DrwebAgent> block() {
        Result result = new Result(new ArrayList());
        try {
            int monthCount = this.req.getInt("monthCount", -1);
            if (monthCount != -1) {
                // empty if block
            }
            this.execute();
            return result;
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
            return result;
        }
    }

    public Result<DrwebAgent> delete() throws SQLException, BGException {
        this.execute();
        return new Result(new ArrayList());
    }

    public Result<DrwebAgent> changeTariff() {
        Result result = new Result(new ArrayList());
        try {
            int tariffId = this.req.getInt("tariff", -1);
            if (tariffId != -1) {
                // empty if block
            }
            this.execute();
            return result;
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
            return result;
        }
    }

    public Result<DrwebAgent> change() {
        Result result = new Result(new ArrayList());
        try {
            DrwebAgent agent = (DrwebAgent)this.getDrwebAgentDAO().get(this.req.getInt("agentId", -1));
            result.setAttribute("agent", (Object)agent);
            result.setAttribute("change", (Object)"1");
            result.setAttribute("tariffs", this.getTariffs(false));
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
        }
        return result;
    }

    public Result<DrwebAgent> active() throws SQLException, BGException {
        this.execute();
        return new Result(new ArrayList());
    }

    protected List<DrwebTariff> getTariffs(boolean forNew) throws Exception {
        ArrayList<DrwebTariff> res = new ArrayList<DrwebTariff>();
        DrwebTariffDAO tariffManager = new DrwebTariffDAO(this.con, this.moduleId);
        Contract contract = this.getContract(this.contractId);
        if (contract == null) {
            return tariffManager.getListAll();
        }
        for (DrwebTariff tariff : tariffManager.getListAll()) {
            String groupStr = tariff.getGroupForView();
            if (!Utils.isEmptyString((String)groupStr)) {
                long grTariff = Utils.enumToMask((String)groupStr);
                if ((contract.getGroups() & grTariff) == 0L) continue;
            }
            if (!forNew && tariff.isOnlyForNew()) continue;
            Date date = new Date();
            Date from = tariff.getDateFromView();
            Date to = tariff.getDateToView();
            if (from != null && !TimeUtils.dateBeforeOrEq((Date)from, (Date)date) || to != null && !TimeUtils.dateBeforeOrEq((Date)date, (Date)to)) continue;
            res.add(tariff);
        }
        return res;
    }

    private DrwebApiManager getDrwebApiManager() {
        this.drwebApiManager = new DrwebApiManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
        return Optional.ofNullable(this.drwebApiManager).orElse(this.drwebApiManager);
    }

    private DrwebAgentDAO getDrwebAgentDAO() {
        this.drwebAgentDAO = new DrwebAgentDAO(this.con, this.moduleId);
        return Optional.ofNullable(this.drwebAgentDAO).orElse(this.drwebAgentDAO);
    }
}

