/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DPayment;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentManager;
import ru.bitel.bgbilling.modules.card.server.bean.RevisePayments;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionDealerRevise
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        int mid = this.getIntParameter("mid", -1);
        Date from = this.getDateParameter("from");
        Date until = this.getDateParameter("until");
        String fileString = this.getParameter("file");
        if (id < 0 || mid < 0) {
            return;
        }
        DPaymentManager manager = new DPaymentManager((Preferences)this.moduleSetup, this.con, mid);
        RevisePayments result = manager.revisePayments(id, from, until, fileString);
        this.buildTable("sup_table", result.getList0());
        this.buildTable("mis_table", result.getList1());
        this.buildTable("dis_table", result.getList2());
    }

    private void buildTable(String nodeName, List<DPayment> paymentList) {
        Element table = this.createElement(this.rootNode, nodeName);
        Element data = this.createElement(table, "data");
        for (DPayment payment : paymentList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(payment.getId()));
            row.setAttribute("cid", String.valueOf(payment.getContractId()));
            row.setAttribute("trans", payment.getTransId());
            row.setAttribute("summ", Utils.formatCost((BigDecimal)payment.getSumma()));
            row.setAttribute("date", TimeUtils.format((Date)payment.getDateTime(), (String)"dd.MM.yyyy HH.mm.ss"));
            row.setAttribute("comment", payment.getPaymentComment());
            row.setAttribute("contract", payment.getContractTitle());
            row.setAttribute("status", payment.getStatus() == 1 ? "\u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d" : "\u043e\u0442\u043c\u0435\u043d\u0435\u043d");
        }
    }
}

