/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionGetTopics
extends ActionBase {
    public void doAction() throws Exception {
        Page page = this.getPage();
        TopicListFilter topicListFilter = new TopicListFilter().setContractId(-1).setClosed(this.getBooleanParameter("closed")).setPeriod(this.getPeriod()).setTitle(this.getParameter("title")).setPage(page).setOnlyNew(this.getBooleanParameter("onlynew")).setUserselect(this.getParameter("userselect")).setUserId(this.userId).setTopicId(this.getIntParameter("tid", -1)).setMessage(this.getParameter("message")).setStatus(this.getIntParameter("status", -1));
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Element topicsElement = this.createElement(this.rootNode, "topisc");
        Page.setRecordCount((Page)page, (int)topicManager.getTopicCount(topicListFilter));
        this.setPageAttribute(topicsElement, page);
        Map<Integer, String> statusesMap = topicManager.getStatusesMap();
        List<Topic> topicList = topicManager.getTopicList(topicListFilter);
        for (Topic topic : topicList) {
            Object st = null;
            st = topic.getStatus() == 0 ? "\u043d\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d" : (!statusesMap.containsKey(topic.getStatus()) ? "?" : statusesMap.get(topic.getStatus()));
            st = (String)st + " / " + (topic.isClosed() ? "\u0437\u0430\u043a\u0440\u044b\u0442" : "\u043e\u0442\u043a\u0440\u044b\u0442");
            String userMy = "none";
            if (topic.getUserId() > 0) {
                userMy = topic.getUserId() == this.userId.intValue() ? "my" : "notmy";
            }
            Element topicElement = this.createElement(topicsElement, "topic");
            topicElement.setAttribute("id", String.valueOf(topic.getId()));
            topicElement.setAttribute("subject", topic.getTitle());
            topicElement.setAttribute("cid", String.valueOf(topic.getContractId()));
            topicElement.setAttribute("status", (String)st);
            topicElement.setAttribute("statusId", String.valueOf(topic.getStatus()));
            topicElement.setAttribute("statClose", topic.isClosed() ? "\u0437\u0430\u043a\u0440\u044b\u0442" : "\u043e\u0442\u043a\u0440\u044b\u0442");
            topicElement.setAttribute("date", TimeUtils.format((Date)topic.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            topicElement.setAttribute("dateClose", TimeUtils.format((Date)topic.getDateClose(), (String)"dd.MM.yyyy HH:mm:ss"));
            topicElement.setAttribute("comm", Topic.commPrefix[topic.getComm()] + topic.getCommValue());
            topicElement.setAttribute("lastmessage", TimeUtils.format((Date)topic.getLastMessageDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            topicElement.setAttribute("timeFromLastMessage", this.getTime(topic.getSecondsFromLastMessage()));
            topicElement.setAttribute("user", topic.getUserName());
            topicElement.setAttribute("userId", String.valueOf(topic.getUserId()));
            topicElement.setAttribute("contract", topic.getContract());
            topicElement.setAttribute("contract_comment", this.getContractComment(topic));
            topicElement.setAttribute("category_subcategory", topic.getContractComment());
            topicElement.setAttribute("messages", topic.getMessageCount() + " [" + topic.getMessageNewUserCount() + "]");
            topicElement.setAttribute("state", String.valueOf(topic.isClosed()));
            topicElement.setAttribute("packageId", String.valueOf(topic.getContractPackageId()));
            topicElement.setAttribute("userMy", userMy);
            topicElement.setAttribute("autoclose", String.valueOf(topic.isAutoClose()));
            topicElement.setAttribute("cost", String.valueOf(topic.getCost()));
            topicElement.setAttribute("categoryId", String.valueOf(topic.getCategoryId()));
            topicElement.setAttribute("subcategoryId", String.valueOf(topic.getSubcategoryId()));
            topicElement.setAttribute("notificationMode", String.valueOf(topic.getComm()));
            topicElement.setAttribute("notificationValue", String.valueOf(topic.getCommValue()));
            topicElement.setAttribute("newMessageCount", String.valueOf(topic.getMessageNewManagerCount()));
            SearchResult messageResult = new SearchResult();
            topicManager.searchTopicMessages((SearchResult<Message>)messageResult, topic.getId());
            this.messages((SearchResult<Message>)messageResult, topicElement, "message");
        }
    }
}

