/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.contract.directory.ListValuesPopupEditor;
import bitel.billing.module.contract.directory.MultiListValuesPopupEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.ContractId;

class NewValuesPanel
extends BGPanel {
    private ListCustomTableModel listCustomTableModel = new ListCustomTableModel();
    private BGUList<BGUListItem> paramsList = new BGUList();
    private ListValuesPopupEditor listParamPopupEditor;
    private String paramId = null;
    protected boolean mode = false;

    public NewValuesPanel(Document moduleDoc, boolean mode) {
        this.moduleDoc = moduleDoc;
        this.mode = mode;
        this.listParamPopupEditor = mode ? new MultiListValuesPopupEditor() : new ListValuesPopupEditor();
        this.listParamPopupEditor.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("UpdateListValue")) {
                this.showlistCustomValue();
            }
        });
        this.jbInit();
        this.paramsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BGUListItem listItem = (BGUListItem)NewValuesPanel.this.paramsList.getSelectedValue();
                    NewValuesPanel.this.paramId = String.valueOf(listItem.getId());
                    NewValuesPanel.this.showlistCustomValue();
                }
            }
        });
        this.listParamPopupEditor.setVisible(false);
    }

    private void jbInit() {
        BGUTable listCustomTable = new BGUTable(this.listCustomTableModel);
        listCustomTable.setSelectionMode(0);
        JPanel listParams = new JPanel(new GridBagLayout());
        listParams.setBorder(this.mode ? new BGTitleBorder("\u041c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043a\u0438") : new BGTitleBorder("C\u043f\u0438\u0441\u043a\u0438"));
        listParams.add((Component)new JScrollPane(this.paramsList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel listCustomTablePanel = new JPanel(new GridBagLayout());
        listCustomTablePanel.setBorder(this.mode ? new BGTitleBorder("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043a\u0430") : new BGTitleBorder("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430"));
        listCustomTablePanel.add((Component)new JScrollPane(listCustomTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel listCustomPanel = new JPanel(new GridBagLayout());
        listCustomPanel.add((Component)listCustomTablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, listParams, (Component)listCustomPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(listCustomTable, e -> this.tableMouseClicked(listCustomTable, (MouseEvent)e));
    }

    private void tableMouseClicked(BGUTable listCustomTable, MouseEvent event) {
        BGUListItem listItem = (BGUListItem)this.paramsList.getSelectedValue();
        ListCustomTableRow row = (ListCustomTableRow)this.listCustomTableModel.getSelectedRow();
        String customValue = row.getCustomValue();
        if (listItem != null) {
            this.listParamPopupEditor.show(listCustomTable, event.getX(), listCustomTable.getHeight());
            this.listParamPopupEditor.setText(customValue);
            this.listParamPopupEditor.init(this.module, this.paramId);
            this.listParamPopupEditor.setCustomValue(customValue);
            this.listParamPopupEditor.setData();
        }
    }

    public void setData(List<BGUListItem> items) {
        this.paramsList.setData(items);
        this.showlistCustomValue();
    }

    public void showlistCustomValue() {
        if (this.paramId != null) {
            Request request = new Request();
            request.setAction(this.mode ? "GetCustomMultiListValue" : "GetCustomListValue");
            request.setModule(this.module);
            request.setAttribute("pid", this.paramId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.tryCall(() -> {
                    ArrayList rows = new ArrayList();
                    XMLUtils.selectElements(doc, "//table/data/row").forEach(a -> {
                        ListCustomTableRow row = new ListCustomTableRow(this);
                        row.setContractId(Utils.parseInt(a.getAttribute("contract_id")));
                        row.setContractTitle(a.getAttribute("contract_title"));
                        row.setCustomValue(a.getAttribute("custom_value"));
                        rows.add(row);
                    });
                    this.listCustomTableModel.setData(rows);
                });
            }
        }
    }

    public boolean getMode() {
        return this.mode;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    class ListCustomTableModel
    extends BGTableModel<ListCustomTableRow> {
        public ListCustomTableModel() {
            super(ListCustomTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 200, 200, 200, "contractTitle", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "customValue", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ListCustomTableRow
    extends ContractId {
        private String contractTitle = "";
        private String customValue = "";

        public ListCustomTableRow(NewValuesPanel this$0) {
        }

        public String getContractTitle() {
            return this.contractTitle;
        }

        public String getCustomValue() {
            return this.customValue;
        }

        @Override
        public ListCustomTableRow setContractId(int contractId) {
            super.setContractId(contractId);
            return this;
        }

        public void setContractTitle(String contractTitle) {
            this.contractTitle = contractTitle;
        }

        public void setCustomValue(String customValue) {
            this.customValue = customValue;
        }
    }
}

