/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.event.UpdateContractEmailEvent;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamEmailData;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamEmailTableCellEditor;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamEmailTableModel;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamEmailToolBar;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamEmailUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;

public class ContractParamEmailEditorDialog
extends BGEditorDialog<ContractParamEditorData> {
    private static final int FONT_SIZE = 14;
    private ParamEmailTableModel tableModel = new ParamEmailTableModel();
    private BGUTable table = new BGUTable(this.tableModel);
    private ParamEmailToolBar toolBar = new ParamEmailToolBar(this.table, this.tableModel);
    private ParamEmailTableCellEditor cellEditor = new ParamEmailTableCellEditor(this.table, 14);

    public ContractParamEmailEditorDialog(String title, ContractParamEditorData data) {
        super(title, data);
    }

    @Override
    public void doDialogPanel() {
        this.table.setDefaultEditor(this.table.getColumnClass(0), this.cellEditor);
        this.table.setRowHeight(22);
        this.table.setFont(new Font("Dialog", 0, 14));
        this.table.setAutoResizeMode(2);
        this.panel.add((Component)new BGTitleLabel(((ContractParamEditorData)this.data).parameterTitle), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.toolBar, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.table, 700, 300), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.tableModel.deleteRows();
        try {
            EntityAttrEmail attrEmail;
            EntityAttrEmail entityAttrEmail = attrEmail = ((ContractParamEditorData)this.data).value != null ? (EntityAttrEmail)((ContractParamEditorData)this.data).value : (EntityAttrEmail)((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterGet(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId);
            if (attrEmail != null) {
                attrEmail.getContactList().forEach(a -> this.tableModel.addRow(new ParamEmailData().setEmail(a.getAddress()).setName(a.getName().trim())));
            }
            this.tableModel.addRow(new ParamEmailData());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public boolean doApply() throws Exception {
        if (!ParamEmailUtils.inspectionEmail(this.table)) {
            return false;
        }
        this.cellEditor.stopCellEditing();
        EntityAttrEmail attrEmail = new EntityAttrEmail(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId);
        this.tableModel.getRows().forEach(a -> attrEmail.addContact(a.getName(), a.getEmail()));
        switch (((ContractParamEditorData)this.data).entityType) {
            case CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterEmailUpdate(((ContractParamEditorData)this.data).contractId, attrEmail);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ContractParamEditorData)this.data).contractId));
                EventBus.publish((Object)new UpdateContractEmailEvent(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId));
                break;
            }
            case NEW_CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).value = attrEmail.getContactList().isEmpty() ? null : attrEmail;
                break;
            }
        }
        return true;
    }
}

