/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.filestorage.server;

import jakarta.activation.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class FileStorage {
    public static final String FILE_STORAGE_ROOT_PATH = "file.storage.root.path";
    public static final String FILE_NET_SHARE_ROOT_PATH = "file.net.share.root.path";
    private String rootPath;
    private String tableName = null;
    private Connection con = null;
    protected int moduleId = 0;

    public FileStorage(Connection con) throws BGException {
        this(con, 0);
    }

    public FileStorage(Connection con, int moduleId) throws BGException {
        this.con = con;
        this.moduleId = moduleId;
        this.rootPath = this.getRootPath();
        String storageId = this.getStorageId();
        if (storageId != null) {
            this.tableName = "filestorage_files_list_" + storageId;
            try {
                this.makeTable();
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        if (this.rootPath == null) {
            throw new BGException("FileStorage rootPath is null (check file.storage.root.path value?)");
        }
    }

    protected abstract String getStorageId();

    protected abstract String getRootPath();

    public String getFileName(int fileId, String fileExtension) {
        String path;
        String sfid = String.valueOf(fileId);
        StringBuffer fname = new StringBuffer(64);
        for (int index = 0; index < sfid.length(); ++index) {
            if (index % 2 == 0) {
                fname.append(File.separatorChar);
            }
            fname.append(sfid.charAt(index));
        }
        final String root = this.rootPath + fname.toString();
        FilenameFilter fileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FilenameUtils.getBaseName((String)name).equals(FilenameUtils.getBaseName((String)root));
            }
        };
        try {
            path = root.substring(0, root.lastIndexOf(File.separatorChar));
        }
        catch (IndexOutOfBoundsException exception) {
            path = FilenameUtils.getPath((String)root);
        }
        File[] files = new File(path).listFiles(fileNameFilter);
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                return path + File.separatorChar + file.getName();
            }
        }
        return this.rootPath + fname.toString() + "." + (Utils.isEmptyString(fileExtension) ? "dat" : fileExtension);
    }

    public String getFileName(int fileId) {
        return this.getFileName(fileId, null);
    }

    private void makeTable() throws SQLException {
        String query = "CREATE TABLE " + this.tableName + " ( id INTEGER NOT NULL AUTO_INCREMENT, id_owner INTEGER NOT NULL, title VARCHAR(255) NOT NULL, size INTEGER NOT NULL, date TIMESTAMP NOT NULL, user INTEGER NOT NULL, comment TEXT, uuid VARCHAR(50) NOT NULL, PRIMARY KEY (id), KEY ( id_owner ) )";
        ServerUtils.checkTable((Connection)this.con, (String)this.tableName, (String)query);
    }

    public FileOutputStream save(int fileId, String fileExtension) throws IOException {
        File file = new File(this.getFileName(fileId, fileExtension));
        File filedir = new File(file.getParent());
        filedir.mkdirs();
        if (!filedir.exists() || !filedir.isDirectory()) {
            throw new IOException("\u041a\u0430\u043a\u0438\u0435-\u0442\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435\u043c \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0433\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430 " + filedir.getAbsolutePath());
        }
        file.createNewFile();
        return new FileOutputStream(file);
    }

    public Path savePath(int fileId, String fileExtension) throws IOException {
        Path path = Paths.get(this.getFileName(fileId, fileExtension), new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    public FileOutputStream save(int fileId) throws IOException {
        return this.save(fileId, null);
    }

    public void saveStream(int fileId, InputStream is, String fileExtension) throws IOException {
        FileOutputStream out = this.save(fileId, fileExtension);
        Utils.flush(is, out);
        out.close();
    }

    public void saveFile(int fileId, Path srcPath, String fileExtension) throws IOException {
        Files.move(srcPath, this.savePath(fileId, fileExtension), new CopyOption[0]);
    }

    public void saveStream(int fileId, InputStream is) throws IOException {
        this.saveStream(fileId, is, null);
    }

    public FileInputStream load(int fileId) throws FileNotFoundException {
        return new FileInputStream(new File(this.getFileName(fileId)));
    }

    public void loadStream(int fileId, OutputStream out) throws FileNotFoundException, IOException {
        FileInputStream is = this.load(fileId);
        Utils.flush(is, out);
        is.close();
    }

    public void checkFileExist(int fileId) throws FileNotFoundException {
        File file = new File(this.getFileName(fileId));
        if (!file.exists()) {
            throw new FileNotFoundException("not exist file id=" + fileId + " (" + String.valueOf(file) + ")");
        }
    }

    public DataSource getDataSource(int fileId) throws FileNotFoundException {
        return this.getDataSource(fileId, "TEST");
    }

    public DataSource getDataSource(final int fileId, final String name) throws FileNotFoundException {
        return new DataSource(){

            public String getContentType() {
                return "application/octet-stream";
            }

            public InputStream getInputStream() throws IOException {
                return FileStorage.this.load(fileId);
            }

            public String getName() {
                return name;
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        };
    }

    public void deleteFile(int fileId, String fileExtension) throws BGException {
        File file = new File(this.getFileName(fileId));
        if (!file.exists()) {
            file = new File(this.getFileName(fileId));
        }
        file.delete();
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");){
            ps.setInt(1, fileId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void deleteFile(int fileId) throws BGException {
        this.deleteFile(fileId, null);
    }

    public void deleteByOwner(int ownerId, String fileExtension) throws SQLException {
        String query = "SELECT id FROM " + this.tableName + " WHERE id_owner=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, ownerId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            try {
                int fileId = rs.getInt(1);
                File file = new File(this.getFileName(fileId));
                if (!file.exists()) {
                    file = new File(this.getFileName(fileId));
                }
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rs.close();
        ps.close();
        query = "DELETE FROM " + this.tableName + " WHERE id_owner=?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, ownerId);
        ps.executeUpdate();
        ps.close();
    }

    public void deleteByOwner(int ownerId) throws SQLException {
        this.deleteByOwner(ownerId, null);
    }

    public List<BGServerFile> getFilesListByOwner(int ownerId) throws BGException {
        return this.getFilesListByOwner(ownerId, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<BGServerFile> getFilesListByOwner(int ownerId, String uuid) throws BGException {
        ArrayList<BGServerFile> result = new ArrayList<BGServerFile>();
        String query = "SELECT df.*  FROM " + this.tableName + " AS df  WHERE df.id_owner=" + ownerId + (uuid != null ? " AND uuid=?" : "") + " ORDER BY df.date DESC ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ArrayList<BGServerFile> arrayList;
            block16: {
                if (uuid != null) {
                    ps.setString(1, uuid);
                }
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        BGServerFile documentFile = new BGServerFile();
                        FileStorage.loadFilesFromRS(documentFile, rs, "df.");
                        result.add(documentFile);
                    }
                    arrayList = result;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public boolean hasFilesByOwner(int ownerId) throws BGException {
        try {
            boolean result = false;
            String query = "SELECT df.* FROM " + this.tableName + " AS df WHERE df.id_owner=" + ownerId;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private static void loadFilesFromRS(BGServerFile file, ResultSet rs, String tableDocumentFile) throws SQLException {
        file.setId(rs.getInt(tableDocumentFile + "id"));
        file.setOwnerId(rs.getInt(tableDocumentFile + "id_owner"));
        file.setTitle(rs.getString(tableDocumentFile + "title"));
        file.setSize(rs.getLong(tableDocumentFile + "size"));
        file.setDate(rs.getTimestamp(tableDocumentFile + "date"));
        file.setUserId(rs.getInt(tableDocumentFile + "user"));
        file.setComment(rs.getString(tableDocumentFile + "comment"));
        file.setUuid(rs.getString(tableDocumentFile + "uuid"));
    }

    public void updateFile(BGServerFile file) throws BGException {
        boolean update = file.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET id_owner=?, title=?, size=?, date=?, user=?, comment=?, uuid=? " + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, file.getOwnerId());
            ps.setString(index++, file.getTitle());
            ps.setLong(index++, file.getSize());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp(file.getDate()));
            ps.setInt(index++, file.getUserId());
            ps.setString(index++, file.getComment());
            ps.setString(index++, file.getUuid());
            if (update) {
                ps.setInt(index++, file.getId());
            }
            ps.executeUpdate();
            if (!update) {
                file.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public BGServerFile getFileById(int fileId) throws BGException {
        BGServerFile documentFile = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    documentFile = new BGServerFile();
                    FileStorage.loadFilesFromRS(documentFile, rs, "");
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return documentFile;
    }
}

