/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.common.ParameterMap;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private final BigDecimal multiplicand;
    protected final String multMode;
    protected final int tariffVarId;

    public MultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        this.multMode = parameterMap.get("multMode", "const");
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("multiplicand = " + String.valueOf(this.multiplicand) + "; multMode = " + this.multMode + "; tariffVarId = " + this.tariffVarId);
        }
    }

    @Override
    public int executeImpl(Long treeNodeId, AbstractTariffRequest<?> tariffRequest, TariffContext tariffContext) {
        if (((ServiceCost)tariffRequest.serviceCost).cost != null) {
            String value;
            BigDecimal inMultiplicand = this.multiplicand;
            if ("var".equals(this.multMode) && (value = tariffRequest.getContractTariffVarValue(this.tariffVarId)) != null) {
                inMultiplicand = new BigDecimal(value);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tariffRequest.serviceCost.cost(before) = " + String.valueOf(((ServiceCost)tariffRequest.serviceCost).cost));
            }
            ((ServiceCost)tariffRequest.serviceCost).cost = ((ServiceCost)tariffRequest.serviceCost).cost.multiply(inMultiplicand, tariffContext.mc);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tariffRequest.serviceCost.cost(after) = " + String.valueOf(((ServiceCost)tariffRequest.serviceCost).cost));
            }
            return 1;
        }
        return 0;
    }
}

