/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.list;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class BGURadioList<I extends IdTitle>
extends JPanel {
    private DefaultListModel<ListItem> dataModel = new DefaultListModel();
    private final JList<ListItem> list = new JList<ListItem>(this.dataModel);
    private JPanel panel = new JPanel(new GridLayout(1, 0, 5, 0));

    public BGURadioList() {
        super(new GridBagLayout());
        this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGButton buttonSelect = new BGButton();
        buttonSelect.setActionCommand("all");
        buttonSelect.setMargin(new Insets(2, 2, 2, 2));
        buttonSelect.setText("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        buttonSelect.addActionListener(e -> this.buttonSelectPressed());
        this.panel.add(buttonSelect);
        this.add((Component)this.panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.dataModel.clear();
        this.list.setModel(this.dataModel);
        this.list.setCellRenderer(new CheckListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (BGURadioList.this.list.isEnabled() && e.getButton() == 1 && e.getClickCount() == 2) {
                    BGURadioList.this.buttonSelectPressed();
                }
            }
        });
    }

    private void buttonSelectPressed() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            ListItem item = this.dataModel.getElementAt(i);
            item.selected = i == selected;
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public void setButtonPanelVisible(boolean b) {
        this.panel.setVisible(b);
    }

    public void setSelected(I selected) {
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            ListItem item = this.dataModel.getElementAt(i);
            item.selected = ((Id)item.item).equals(selected);
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public void setSelectedId(int id) {
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            ListItem item = this.dataModel.getElementAt(i);
            item.selected = ((Id)item.item).getId() == id;
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public I getSelected() {
        I result = null;
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            ListItem item = this.dataModel.getElementAt(i);
            if (!item.selected) continue;
            result = item.item;
            break;
        }
        return result;
    }

    public void setData(List<I> data) {
        this.dataModel.clear();
        for (IdTitle i : data) {
            ListItem item = new ListItem(this);
            item.item = i;
            this.dataModel.addElement(item);
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    private class CheckListCellRenderer
    extends JRadioButton
    implements ListCellRenderer<ListItem> {
        Border m_noFocusBorder = new EmptyBorder(1, 5, 1, 5);

        public CheckListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.m_noFocusBorder);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ListItem> list, ListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setText(value.toString());
            this.setSelected(value.selected);
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }

    private class ListItem {
        I item;
        boolean selected;

        private ListItem(BGURadioList bGURadioList) {
        }

        public String toString() {
            return ((IdTitle)this.item).getTitle();
        }
    }
}

