/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext;

import bitel.billing.server.ext.ExtSetup;
import bitel.billing.server.ext._ProcessorThreadFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class DatagramChannelListener<S>
extends Thread
implements _ProcessorThreadFactory {
    protected final Logger log;
    protected final int port;
    protected final DatagramChannel channel;
    protected final Selector selector;
    protected final ThreadPoolExecutor pool;
    protected final int threadCount;
    private ByteBuffer directByteBuffer;
    protected int maxPacketSize = 4095;
    protected int byteBufferCapacity;
    protected final _ProcessorThreadFactory processorThreadFactory;
    private volatile boolean running = true;
    protected final S setup;

    public DatagramChannelListener(int port, int threadCount, boolean multiThread, Logger log, S setup) {
        this(port, threadCount, multiThread, log, 4000000, null, setup);
    }

    public DatagramChannelListener(int port, int threadCount, boolean multiThread, Logger log, ProcessorThreadFactory factory, S setup) {
        this(port, threadCount, multiThread, log, 4000000, factory, setup);
    }

    public DatagramChannelListener(int port, int threadCount, boolean multiThread, Logger log, int byteBufferCapacity, S setup) {
        this(port, threadCount, multiThread, log, byteBufferCapacity, null, setup);
    }

    public DatagramChannelListener(int port, int threadCount, boolean multiThread, Logger log, int byteBufferCapacity, ProcessorThreadFactory factory, S setup) {
        ByteBuffer buffer;
        Selector selector;
        DatagramChannel channel;
        this.port = port;
        this.threadCount = threadCount;
        this.log = log;
        this.byteBufferCapacity = byteBufferCapacity;
        this.setup = setup;
        this.processorThreadFactory = factory == null ? this : factory;
        try {
            channel = DatagramChannel.open();
            selector = Selector.open();
            buffer = ByteBuffer.allocateDirect(byteBufferCapacity);
        }
        catch (Exception e) {
            Object channel2 = null;
            Object selector2 = null;
            Object buffer2 = null;
            e.printStackTrace();
            throw new RuntimeException("Error init DatagramChannelListener");
        }
        this.channel = channel;
        this.selector = selector;
        this.directByteBuffer = buffer;
        this.pool = this.newThreadPoolExecutor(multiThread);
    }

    protected ThreadPoolExecutor newThreadPoolExecutor(boolean multiThread) {
        RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    DatagramChannelListener.this.log.warn("Wating for free Thread..");
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    executor.execute(r);
                }
            }
        };
        return this.newThreadPoolExecutor(multiThread, rejectedExecutionHandler);
    }

    protected ThreadPoolExecutor newThreadPoolExecutor(boolean multiThread, RejectedExecutionHandler rejectedExecutionHandler) {
        if (multiThread) {
            return new ThreadPoolExecutor(0, this.threadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), rejectedExecutionHandler);
        }
        return new ThreadPoolExecutor(this, 0, this.threadCount, 60L, TimeUnit.SECONDS, new SynchronousQueue(), rejectedExecutionHandler){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
    }

    protected ThreadFactory newThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    private void initSocket() {
        try {
            InetSocketAddress localport = new InetSocketAddress(this.port);
            this.channel.socket().bind(localport);
            this.channel.socket().setBroadcast(true);
            this.channel.configureBlocking(false);
            this.channel.register(this.selector, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error init SocketListener on port=" + this.port);
        }
    }

    public void shutdown(boolean wait) {
        this.running = false;
        this.pool.shutdown();
        if (wait) {
            try {
                while (this.isAlive() || !this.pool.isTerminated()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.selector.select();
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    SelectableChannel c = key.channel();
                    if (!key.isReadable() || c != this.channel) continue;
                    if (this.directByteBuffer.capacity() - this.directByteBuffer.position() < this.maxPacketSize) {
                        this.directByteBuffer = ByteBuffer.allocateDirect(this.byteBufferCapacity);
                    }
                    this.directByteBuffer.mark();
                    SocketAddress clientAddress = this.channel.receive(this.directByteBuffer);
                    if (clientAddress == null) continue;
                    this.directByteBuffer.limit(this.directByteBuffer.position());
                    this.directByteBuffer.reset();
                    ByteBuffer buffer = this.directByteBuffer.slice();
                    this.directByteBuffer.position(this.directByteBuffer.limit());
                    this.directByteBuffer.limit(this.directByteBuffer.capacity());
                    Runnable thread = this.processorThreadFactory.createProcessingRunnable(clientAddress, buffer);
                    if (thread == null) continue;
                    this.pool.execute(thread);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void init() {
        this.initSocket();
    }

    @Override
    public Runnable createProcessingRunnable(SocketAddress clientAddress, ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    public void sendResponse(SocketAddress address, ByteBuffer response) throws IOException {
        this.channel.send(response, address);
    }

    public static interface ProcessorThreadFactory
    extends _ProcessorThreadFactory {
    }

    public static abstract class PoolingWorkerThreadFactory<N extends PoolingWorkerManager<S>, S extends ExtSetup>
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String namePrefix;
        protected final S setup;

        public PoolingWorkerThreadFactory(S setup) {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
            this.setup = setup;
        }

        @Override
        public PoolingWorkerThread<?, ?> newThread(Runnable r) {
            return this.init(new PoolingWorkerThread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L, this.setup, this));
        }

        public abstract N newPoolingWorker(S var1, Connection var2);

        public PoolingWorkerThread<?, ?> init(PoolingWorkerThread<?, ?> t) {
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static final class PoolingWorkerThread<N extends PoolingWorkerManager<S>, S extends ExtSetup>
    extends Thread {
        private final S setup;
        private final Runnable target;
        private final PoolingWorkerThreadFactory<N, S> factory;
        private N worker;

        public PoolingWorkerThread(ThreadGroup group, Runnable target, String name, long stackSize, S setup, PoolingWorkerThreadFactory<N, S> factory) {
            super(group, null, name, stackSize);
            this.setup = setup;
            this.target = target;
            this.factory = factory;
        }

        @Override
        public void run() {
            Connection con = ((DefaultServerSetup)((Object)this.setup)).getDBConnectionFromPool();
            try {
                this.worker = this.factory.newPoolingWorker(this.setup, con);
                this.target.run();
            }
            finally {
                ServerUtils.closeConnection(con);
                con = null;
                this.worker = null;
            }
        }

        public N getWorkerForThread() {
            return this.worker;
        }
    }

    public static class PoolingWorkerManager<S> {
        protected final S setup;
        protected final Connection con;

        public PoolingWorkerManager(S setup, Connection con) {
            this.setup = setup;
            this.con = con;
        }
    }

    public static abstract class ProcessingRunnable<N extends PoolingWorkerManager<?>>
    implements Runnable {
        protected N manager;

        public void setManager(N manager) {
            this.manager = manager;
        }
    }
}

