/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.script.common.bean.EventScriptLink;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class EventScriptLinkDao
extends AbstractIdDao<EventScriptLink> {
    public EventScriptLinkDao(Connection con) {
        super(con, "event_script_link");
    }

    protected EventScriptLink getFromRS(ResultSet rs) throws SQLException {
        EventScriptLink link = new EventScriptLink();
        link.setClassName(rs.getString("class_name"));
        link.setEventKey(rs.getString("event_key"));
        link.setId(rs.getInt("id"));
        link.setScriptId(rs.getInt("script_id"));
        link.setTitle(rs.getString("title"));
        return link;
    }

    protected void updateImpl(EventScriptLink eventScriptLink) throws SQLException {
        String querySet = "class_name=?, event_key=?, script_id=?, title=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)eventScriptLink, querySet);){
            int index = 1;
            ps.setString(index++, eventScriptLink.getClassName());
            ps.setString(index++, eventScriptLink.getEventKey());
            ps.setInt(index++, eventScriptLink.getScriptId());
            ps.setString(index++, eventScriptLink.getTitle());
            this.executeUpdate((Id)eventScriptLink, index, ps);
        }
    }

    public List<EventScriptLink> getScriptLinkListByScript(int scriptId) throws SQLException {
        return this.list("script_id=?", "title", new Object[]{scriptId});
    }

    public List<EventScriptLink> getScriptLinkList() throws SQLException {
        return this.list("", "title", new Object[0]);
    }
}

