/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.list.renderer.TitleIdListCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.tariff.option.client.TariffOptionActivateModesEditor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class TariffOptionServiceConfig
extends BGUPanel {
    private BGUList<TariffOption> tariffOptionList;
    private TariffOptionService tariffOptionService;
    private ConfigOptionTableModel configOptionTableModel;

    public TariffOptionServiceConfig(ClientContext clientContext) {
        super(clientContext);
    }

    protected void jbInit() {
        try {
            BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getLeftPanel(), (Component)this.getEditorPanel(), 400L);
            this.setLayout(new GridBagLayout());
            this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private JPanel getLeftPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTariffOptionPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getConfigOptionPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getTariffOptionPanel() {
        this.tariffOptionList = new BGUList();
        this.tariffOptionList.setCellRenderer((ListCellRenderer)new TitleIdListCellRenderer());
        this.tariffOptionList.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked(this.tariffOptionList, e -> this.performAction("edit"));
        JScrollPane scrollPane = new JScrollPane((Component)this.tariffOptionList);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TariffOptionServiceConfig.this.tariffOptionList.setFixedCellWidth(TariffOptionServiceConfig.this.tariffOptionList.getParent().getWidth() - 20);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438 "), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getConfigOptionPanel() {
        this.configOptionTableModel = new ConfigOptionTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.configOptionTableModel));
        table.setSelectionMode(0);
        Dimension dimension = new Dimension(100, 200);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041e\u043f\u0446\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 "), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private BGEditor getEditorPanel() throws Exception {
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e", 0), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 50, 0, 50), 0, 0));
        TariffOptionEditor editor = new TariffOptionEditor();
        Request request = new Request().setModule("tariff").setAction("ListTariffPlans");
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            editor.tariffPlans.getList().setData(ClientUtils.toBGUListItemList((Iterable)XMLUtils.selectElements((Node)doc, (String)"//tariffPlans/item")));
        }
        BGEditor rightPanel = new BGEditor("info");
        rightPanel.addForm((JComponent)labelPanel, (Object)"info");
        rightPanel.addForm((JComponent)((Object)editor));
        rightPanel.addPropertyChangeListener(e -> {
            if ("show".equals(e.getPropertyName()) && "info".equals(e.getNewValue())) {
                this.tariffOptionList.setEnabled(true);
            }
        });
        return rightPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.tariffOptionList != null) {
                this.tariffOptionList.setData(this.getTariffOptionService().tariffOptionList());
                this.tariffOptionList.setFixedCellWidth(this.tariffOptionList.getParent().getWidth() - 20);
            }
            if (this.configOptionTableModel != null) {
                ArrayList rowDatas = new ArrayList();
                new JSONArray(this.getTariffOptionService().configOption()).forEach(a -> rowDatas.add(new RowData((JSONObject)a)));
                this.configOptionTableModel.setData(rowDatas);
            }
        });
    }

    private TariffOptionService getTariffOptionService() {
        if (this.tariffOptionService == null) {
            this.tariffOptionService = (TariffOptionService)((ClientContext)this.getContext()).getPort(TariffOptionService.class);
        }
        return this.tariffOptionService;
    }

    class ConfigOptionTableModel
    extends BGTableModel<RowData> {
        public ConfigOptionTableModel() {
            super(ConfigOptionTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041e\u043f\u0446\u0438\u044f", 100, 200, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 100, 100, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
        }

        public Object getValue(RowData val, int column) throws Exception {
            String i;
            JSONObject json = val.getJson();
            switch (i = this.getIdentifier(column)) {
                case "name": {
                    return json.optString(i);
                }
                case "value": {
                    return json.optBoolean(i);
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class TariffOptionEditor
    extends BGUPanel {
        private String id;
        private BGTextField titleTF;
        private BGControlPanelListSelect tariffPlans;
        private ContractLabelTree contractLabelTree;
        private TariffOptionActivateModesEditor activateModes;
        private BGUCheckList<TariffOption> dependsList;
        private BGUCheckList<TariffOption> incompatibleList;
        private JCheckBox hide;
        private JRadioButton hideForGroupsModeOr;
        private JRadioButton hideForGroupsModeAnd;
        private ContractLabelTree hideForContractLabels;
        private BGConfigEditorPane config;
        private JTextArea comment;
        private JTextArea description;

        public TariffOptionEditor() {
            super((LayoutManager)new GridBagLayout());
            this.id = null;
            this.titleTF = new BGTextField();
            this.tariffPlans = new BGControlPanelListSelect(5);
            this.activateModes = new TariffOptionActivateModesEditor();
            this.dependsList = new BGUCheckList();
            this.incompatibleList = new BGUCheckList();
            this.hide = new JCheckBox("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435");
            this.hideForGroupsModeOr = new JRadioButton("\u0418\u041b\u0418");
            this.hideForGroupsModeAnd = new JRadioButton("\u0418");
            this.config = new BGConfigEditorPane();
            this.comment = new JTextArea();
            this.description = new JTextArea();
        }

        protected void jbInit() throws BGException {
            this.contractLabelTree = new ContractLabelTree();
            this.hideForContractLabels = new ContractLabelTree();
            JPanel titlePanel = new JPanel(new GridBagLayout());
            titlePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            titlePanel.add((Component)this.titleTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 0, 5), 0, 0));
            JTabbedPane editorTabPanel = new JTabbedPane();
            editorTabPanel.addTab("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b", (Component)this.tariffPlans);
            editorTabPanel.addTab("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", new JScrollPane(this.contractLabelTree));
            editorTabPanel.addTab("\u0420\u0435\u0436\u0438\u043c\u044b \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", (Component)((Object)this.activateModes));
            JPanel dependsPanel = new JPanel(new GridBagLayout());
            dependsPanel.add((Component)BGSwingUtilites.wrapBorder(this.dependsList, (String)"\u0417\u0430\u0432\u0438\u0441\u0438\u0442 \u043e\u0442 \u043e\u043f\u0446\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            dependsPanel.add((Component)BGSwingUtilites.wrapBorder(this.incompatibleList, (String)"\u041d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u043e\u043f\u0446\u0438\u044f\u043c\u0438:"), new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            editorTabPanel.addTab("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438", dependsPanel);
            JPanel panel = new JPanel(new GridBagLayout());
            JPanel hideForContractLabels = new JPanel(new GridBagLayout());
            panel.add((Component)this.hide, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
            hideForContractLabels.setBorder(BorderFactory.createTitledBorder("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"));
            panel.add((Component)hideForContractLabels, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            hideForContractLabels.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 5), 0, 0));
            hideForContractLabels.add((Component)this.hideForGroupsModeOr, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
            hideForContractLabels.add((Component)this.hideForGroupsModeAnd, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
            hideForContractLabels.add((Component)new JScrollPane(this.hideForContractLabels), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            ButtonGroup group = new ButtonGroup();
            group.add(this.hideForGroupsModeOr);
            group.add(this.hideForGroupsModeAnd);
            editorTabPanel.addTab("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c", panel);
            this.comment.setLineWrap(true);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.description.setLineWrap(true);
            this.description.setMargin(new Insets(3, 3, 3, 3));
            JPanel descriptionPanel = new JPanel(new GridBagLayout());
            descriptionPanel.add((Component)BGSwingUtilites.wrapBorder((JComponent)new JScrollPane(this.comment), (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            descriptionPanel.add((Component)BGSwingUtilites.wrapBorder((JComponent)new JScrollPane(this.description), (String)"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            editorTabPanel.addTab("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", descriptionPanel);
            JPanel configPanel = new JPanel(new GridBagLayout());
            configPanel.add((Component)new JScrollPane((Component)this.config), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            editorTabPanel.addTab("\u041a\u043e\u043d\u0444\u0438\u0433", configPanel);
            this.add(titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add(editorTabPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        private void editOption() throws Exception {
            TariffOption option = null;
            List<TariffOption> options = TariffOptionServiceConfig.this.getTariffOptionService().tariffOptionList();
            this.contractLabelTree.loadLabels((ContractLabelService)((ClientContext)this.getContext()).getWebService(ContractLabelService.class));
            this.hideForContractLabels.loadLabels((ContractLabelService)((ClientContext)this.getContext()).getWebService(ContractLabelService.class));
            if (this.id.equals("new")) {
                List<TariffOptionActivateMode> emptyModeList = Collections.emptyList();
                this.titleTF.setText("");
                this.tariffPlans.setListValues("");
                this.contractLabelTree.setSelectedIds(Collections.emptyList());
                this.activateModes.setData(emptyModeList);
                this.hide.setSelected(false);
                this.hideForGroupsModeOr.setSelected(true);
                this.hideForContractLabels.setSelectedIds(Collections.emptyList());
                this.comment.setText("");
                this.description.setText("");
            } else {
                option = TariffOptionServiceConfig.this.getTariffOptionService().tariffOptionGet(Utils.parseInt((String)this.id));
                if (option != null) {
                    this.titleTF.setText(option.getTitle());
                    this.tariffPlans.setListValues(Utils.toString(option.getTariffIdSet()));
                    this.contractLabelTree.setSelectedIds(new ArrayList<Integer>(option.getContractLabels()));
                    this.activateModes.setData(option.getActivateModeList());
                    this.hide.setSelected(option.isHideForWeb());
                    if (option.getHideForContractGroupsMode() == 0) {
                        this.hideForGroupsModeOr.setSelected(true);
                    } else {
                        this.hideForGroupsModeAnd.setSelected(true);
                    }
                    this.hideForContractLabels.setSelectedIds(new ArrayList<Integer>(option.getHideForContractLabels()));
                    this.config.setText(option.getConfig());
                    this.comment.setText(option.getComment());
                    this.description.setText(option.getDescription());
                    options.remove((Object)option);
                }
            }
            this.dependsList.setData(options);
            this.incompatibleList.setData(options);
            if (option != null) {
                this.dependsList.setSelected(option.getDepends());
                this.incompatibleList.setSelected(option.getIncompatible());
            }
            TariffOptionServiceConfig.this.tariffOptionList.setEnabled(false);
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.id = "new";
                this.editOption();
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                TariffOption tariffOption = (TariffOption)((Object)((Object)TariffOptionServiceConfig.this.tariffOptionList.getSelectedValue()));
                if (tariffOption != null) {
                    this.id = String.valueOf(tariffOption.getId());
                    this.editOption();
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                TariffOption tariffOption = (TariffOption)((Object)((Object)TariffOptionServiceConfig.this.tariffOptionList.getSelectedValue()));
                if (tariffOption != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    TariffOptionServiceConfig.this.getTariffOptionService().tariffOptionDelete(tariffOption.getId());
                    TariffOptionServiceConfig.this.performAction("refresh");
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Utils.isBlankString((String)TariffOptionEditor.this.titleTF.getText())) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435.");
                        return;
                    }
                    TariffOption tariffOption = new TariffOption().setId(Utils.parseInt((String)TariffOptionEditor.this.id)).setTitle(TariffOptionEditor.this.titleTF.getText()).setTariffIdSet(Utils.toIntegerSet((String)TariffOptionEditor.this.tariffPlans.getListValues())).setContractLabels(new HashSet<Integer>(TariffOptionEditor.this.contractLabelTree.getSelectedIds())).setActivateModeList(TariffOptionEditor.this.activateModes.getData()).setDepends(TariffOptionEditor.this.dependsList.getSelectedIds()).setIncompatible(TariffOptionEditor.this.incompatibleList.getSelectedIds()).setHideForWeb(TariffOptionEditor.this.hide.isSelected()).setHideForContractGroupsMode(TariffOptionEditor.this.hideForGroupsModeAnd.isSelected() ? 1 : 0).setHideForContractLabels(new HashSet<Integer>(TariffOptionEditor.this.hideForContractLabels.getSelectedIds())).setComment(TariffOptionEditor.this.comment.getText()).setDescription(TariffOptionEditor.this.description.getText()).setConfig(TariffOptionEditor.this.config.getText());
                    TariffOptionServiceConfig.this.getTariffOptionService().tariffOptionUpdate(tariffOption);
                    TariffOptionEditor.this.performActionClose();
                    TariffOptionServiceConfig.this.tariffOptionList.setEnabled(true);
                    TariffOptionServiceConfig.this.performAction("refresh");
                }
            };
        }
    }
}

