/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.message4user.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.plugins.message4user.common.bean.Message;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;

public class MessageForUsersDao
extends AbstractDao<Message> {
    public MessageForUsersDao(Connection con) {
        super(con, "message_for_users");
    }

    protected Message getFromRS(ResultSet rs) throws SQLException, BGException {
        int id = rs.getInt("id");
        Timestamp dateFrom = rs.getTimestamp("date_from");
        Timestamp dateTo = rs.getTimestamp("date_to");
        String messageTitle = rs.getString("title");
        String title = id + " [" + TimeUtils.format((Date)dateFrom, (String)"dd.MM.yyyy HH:mm") + " - " + TimeUtils.format((Date)dateTo, (String)"dd.MM.yyyy HH:mm") + " ] " + messageTitle;
        return new Message(id, title).setDateFrom((Date)dateFrom).setDateTo((Date)dateTo).setText(rs.getString("text")).setRolesIds(Utils.toIntegerSet((String)rs.getString("role_ids"))).setUsers(Utils.toIntegerSet((String)rs.getString("users"))).setMessageTitle(messageTitle);
    }

    protected void updateImpl(Message message) throws BGException, SQLException {
        StringBuilder query = new StringBuilder();
        PreparedStatement ps = null;
        if (message.getId() > 0) {
            query.append("UPDATE ").append(this.tableName).append(" SET date_to=?, date_from=?, text=?, role_ids=?, title=?, users=? WHERE id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(7, message.getId());
        } else {
            query.append("INSERT ").append(this.tableName).append("(date_to, date_from, text, role_ids, title, users) VALUES(?, ?, ?, ?, ?, ?)");
            ps = this.con.prepareStatement(query.toString(), 1);
        }
        ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)message.getDateTo()));
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)message.getDateFrom()));
        ps.setString(3, message.getText());
        ps.setString(4, Utils.toString((Iterable)message.getRolesIds(), (String)","));
        ps.setString(5, message.getMessageTitle());
        ps.setString(6, Utils.toString((Iterable)message.getUsers()));
        ps.executeUpdate();
        if (message.getId() < 0) {
            message.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public List<Message> getMessageList() throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        String query = "SELECT * FROM message_for_users";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            messageList = this.getListFromRS(rs);
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        return messageList;
    }

    public List<Message> getMessageList(int lastMessageId, int userId) throws BGException {
        List messageList;
        String query = "SELECT * FROM message_for_users WHERE id>? AND now() BETWEEN date_from AND date_to";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, lastMessageId);
            try (ResultSet rs = ps.executeQuery();){
                messageList = this.getListFromRS(rs);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (Utils.notEmptyCollection((Collection)messageList)) {
            messageList.removeIf(message -> Utils.notEmptyCollection((Collection)message.getUsers()) && !message.getUsers().contains(userId));
            Optional role = PermissionOfRoles.getRoleByUserId((int)userId);
            if (role.isPresent()) {
                int userRoleId = ((Role)role.get()).getId();
                messageList.removeIf(message -> Utils.notEmptyCollection((Collection)message.getRolesIds()) && !message.getRolesIds().contains(userRoleId));
            }
        }
        return messageList;
    }

    @Deprecated
    public List<Message> getMessageList(int lastMessagId, String userId) throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        String query = "SELECT * FROM message_for_users WHERE id>? AND CONCAT( ',', users, ',' )  LIKE '%," + userId + ",%' AND now() BETWEEN date_from AND date_to";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, lastMessagId);
            try (ResultSet rs = ps.executeQuery();){
                messageList = this.getListFromRS(rs);
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        return messageList;
    }

    public void deleteMessage(int messageId) {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, messageId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
    }
}

