/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.event.worker;

import org.slf4j.MDC;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class TinkoffCheckEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;

    public TinkoffCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), TinkoffCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting TinkoffCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "tinkoff-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        TinkoffCheckEvent event = (TinkoffCheckEvent)((Object)task);
        MDC.put((String)"module", (String)"tinkoff");
        MDC.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        MDC.put((String)"contractId", (String)String.valueOf(event.getContractId()));
        this.getLogger().debug("event.isAutopaymentTransaction() = {}", (Object)event.isAutopaymentTransaction());
        try {
            this.transactionManager.doResend();
            this.transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            Object var3_3 = null;
            return var3_3;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            MDC.remove((String)"module");
            MDC.remove((String)"moduleId");
            MDC.remove((String)"contractId");
        }
    }
}

