/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.client;

import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.common.bean.emuns.PaymentType;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.alfabank.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.alfabank.common.service.AlfabankService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected JMenuItem getTransactionDataMenuItem() {
        return new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        JTextArea textArea = new JTextArea(transaction.getParameters(), 20, 50);
                        textArea.setMargin(new Insets(5, 5, 5, 5));
                        textArea.setEditable(false);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), new JScrollPane(textArea), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", 1);
                    }
                });
            }
        };
    }

    protected JMenuItem getTransactionStatusMenuItem() {
        return new JMenuItem("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        TransactionPanel.this.tryCall(() -> {
                            ((AlfabankService)((ClientContext)TransactionPanel.this.getContext()).getPort(AlfabankService.class)).checkTransaction(transaction.getId());
                            TransactionPanel.this.performAction("refresh");
                        });
                    }
                });
            }
        };
    }

    protected BGButton getCheckButton() {
        BGButton button = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c...");
        button.setToolTipText("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u0441\u0435\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439");
        button.addActionListener(e -> this.tryCall(() -> {
            ((AlfabankService)((ClientContext)this.getContext()).getPort(AlfabankService.class)).checkTransactions(this.getContractId());
            this.performAction("refresh");
        }));
        return button;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchParam searchParam = null;
            int recordId = Utils.parseInt((String)this.idField.getText());
            searchParam = recordId > 0 ? new SearchParam().setRecordId(recordId).setPage(this.pagePanel.getPage()) : new SearchParam().setContractId(this.getContractId()).setContractTitle(this.contractTitleField.getText()).setStatus(((AbstractTransactionStatus)this.statusComboBox.getSelectedItem()).getCode()).setType((PaymentType)Optional.ofNullable(this.paymentTypes).map(a -> (KeyValue)a.getSelectedItem()).map(a -> PaymentType.getPaymentTypeByName((String)a.getKey())).orElse(null)).setMethod((String)Optional.ofNullable(this.paymentMethods).map(a -> (String)a.getSelectedItem()).orElse(null)).setPeriod(this.periodPanel.getPeriod()).setPage(this.pagePanel.getPage()).setSort(this.getTable().getSort());
            SearchResult searchResult = ((AlfabankService)((ClientContext)this.getContext()).getPort(AlfabankService.class)).searchTransactionList(searchParam);
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
    }
}

