/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc;

import java.math.BigDecimal;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.atolonlinev4.AtolOnlineV4Fiscalizator;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.atolonlinev5.AtolOnlineV5Fiscalizator;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.cashcheckserver.CashCheckServerFiscalizator;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.empty.EmptyFiscalizator;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.fermaofdru.FermaofdruFiscalizator;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.komtet.KomtetFiscalizator;
import ru.bitel.common.function.ThrowingConsumer;

public abstract class Fiscalizator {
    protected Printer printer;
    private static final BGMessageException NO_IMPL_EX = new BGMessageException("\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");

    public Fiscalizator(Printer printer) throws BGException {
        this.printer = printer;
    }

    public void buzzer(String oppass) throws BGException {
    }

    public void cancelcheck(String oppass) throws BGException {
        throw NO_IMPL_EX;
    }

    public String closecheck_fix(String oppass, BigDecimal summa) throws BGException {
        throw NO_IMPL_EX;
    }

    public void continueprint(String oppass) throws BGException {
        throw NO_IMPL_EX;
    }

    public void divreport(String adminpass) throws BGException {
        throw NO_IMPL_EX;
    }

    public void openday(String adminpass) throws BGException {
        throw NO_IMPL_EX;
    }

    public void printtext(String oppass, String text) throws BGException {
        throw NO_IMPL_EX;
    }

    public void repeatcheck(String oppass) throws BGException {
        throw NO_IMPL_EX;
    }

    public void xreport(String adminpass) throws BGException {
        throw NO_IMPL_EX;
    }

    public void zreport(String adminpass) throws BGException {
        throw NO_IMPL_EX;
    }

    public String purecommand(String pass, String hexdump) throws BGException {
        throw NO_IMPL_EX;
    }

    public abstract CheckPrintResult check(String var1, BigDecimal var2, Check var3) throws BGException;

    public abstract CheckPrintResult checkreturn(String var1, BigDecimal var2, Check var3) throws BGException;

    public abstract String status(String var1) throws BGException;

    public abstract String name(String var1) throws BGException;

    public abstract String getFiscalizatorStatus() throws BGException;

    public abstract boolean isAsynchronous();

    public static Fiscalizator getFiscalizatorImpl(Printer.FiscalizatorType fiscalizatorType, Printer printer) throws BGException {
        switch (fiscalizatorType) {
            case cashcheckserver: {
                return new CashCheckServerFiscalizator(printer);
            }
            case empty: {
                return new EmptyFiscalizator(printer);
            }
            case atolonlinev4: {
                return new AtolOnlineV4Fiscalizator(printer);
            }
            case atolonlinev5: {
                return new AtolOnlineV5Fiscalizator(printer);
            }
            case dyncode: {
                String fiscalizatorClass = printer.getConfig().get("dyncode");
                if (fiscalizatorClass != null) {
                    try {
                        return (Fiscalizator)DynamicClassManager.getInstance().newInstance(Fiscalizator.class, fiscalizatorClass, new Class[]{Printer.class}, new Object[]{printer});
                    }
                    catch (ClassCastException e) {
                        throw new BGException("requires Fiscalizator-implemented dyncode (dyncode=" + fiscalizatorClass + ")");
                    }
                }
                throw new BGException("requires \"dyncode\" parameter)");
            }
            case fermaofdru: {
                return new FermaofdruFiscalizator(printer);
            }
            case komtet: {
                return new KomtetFiscalizator(printer);
            }
        }
        throw new UnsupportedOperationException("unknown fiscalizator type");
    }

    public void checkPending(List<String> pendingIds, long timeout, ThrowingConsumer<CheckResult> eachResult) throws BGException {
        throw new UnsupportedOperationException("checkPending not implemented");
    }

    public static class CheckResult {
        public String pendingId;
        public Result result;
        public String error;
        public CheckFiscalData data;

        public CheckResult(String pendingId, Result result, String error, CheckFiscalData data) {
            this.pendingId = pendingId;
            this.result = result;
            this.error = error;
            this.data = data;
        }

        public static CheckResult ok(String pendingId, CheckFiscalData data) {
            return new CheckResult(pendingId, Result.OK, null, data);
        }

        public static CheckResult wait(String pendingId) {
            return new CheckResult(pendingId, Result.WAIT, null, null);
        }

        public static CheckResult error(String pendingId, String error) {
            return new CheckResult(pendingId, Result.ERROR, error, null);
        }

        public static enum Result {
            OK,
            WAIT,
            ERROR;

        }
    }
}

