/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseOption;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseOptionDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class TableOption
extends BGTableInfoBase {
    public TableOption() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (String)"title").setWidth(400), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (String)"comment").setWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"\u0423\u0441\u043b\u0443\u0433\u0430 (smarthouse)", (String)"smarthouse_service").setWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"\u0423\u0441\u043b\u0443\u0433\u0430 (npay)", (String)"npay_service").setWidth(-1), BGUTableColumn.buildColumnId()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        ModuleCache moduleCache = ModuleCache.getInstance();
        List smarthouseServices = moduleCache.getModuleServicesList(moduleId);
        List npayModules = moduleCache.getModulesList("npay");
        HashMap npayServices = new HashMap();
        npayModules.forEach(a -> npayServices.putAll(moduleCache.getModuleServicesList(a.getId()).stream().collect(Collectors.toMap(Id::getId, IdTitle::getTitle))));
        Connection con = this.getContext().getConnection();
        for (SmartHouseOption option : new SmartHouseOptionDao(con, moduleId).list()) {
            String smarthouseService = option.getSmarthouseServiceId() == 0 ? "" : smarthouseServices.stream().filter(a -> a.getId() == option.getSmarthouseServiceId()).findFirst().map(a -> a.getTitle()).orElse("");
            String npayService = option.getNpayModuleId() == 0 ? "" : npayModules.stream().filter(a -> a.getId() == option.getNpayModuleId()).findFirst().map(a -> a.getTitle()).orElse("??? [#" + option.getNpayModuleId() + "]") + ": " + Optional.ofNullable((String)npayServices.get(option.getNpayServiceId())).orElse("??? [#" + option.getNpayServiceId() + "]");
            BGUTableRowData rowData = new BGUTableRowData().addValue("title", option.getTitle()).addValue("comment", option.getComment()).addValue("smarthouse_service", smarthouseService).addValue("npay_service", npayService).addValue(this.getId(option.getId()));
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

