/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.eap;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.MSUtils;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPAuthenticator;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMessage;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public final class EAPMSChapV2Authentificator<N extends Nas<?, ?, ?>, P>
implements EAPAuthenticator<N, P> {
    public static byte OPCODE_CHALLENGE = 1;
    public static byte OPCODE_RESPONSE = (byte)2;
    public static byte OPCODE_SUCCESS = (byte)3;
    public static byte OPCODE_FAILURE = (byte)4;
    private static final Logger log = LogManager.getLogger();
    private static final SecureRandom secureRandom = new SecureRandom();
    private EAPSession<N, P> session;
    private State state = State.challenge;
    private byte[] challenge;
    private byte[] authMessage;
    private byte msChapV2Id;
    private byte checkPasswordCount = 0;
    private byte[] challengeResponse;

    public EAPMSChapV2Authentificator(EAPSession<N, P> session) {
        this.session = session;
    }

    @Override
    public EAPMessage authenticate(EAPMessage eap, RadiusSession<N, P> radiusSession, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) throws SSLException {
        EAPMessage out = null;
        switch (this.state.ordinal()) {
            case 1: {
                if (eap.getData().capacity() < 2) {
                    return this.session.reject();
                }
            }
            case 0: {
                log.debug("Checking password");
                byte[] responseBytes = new byte[49];
                ByteBuffer eapData = eap.getData();
                eapData.position(5);
                eapData.get(responseBytes, 0, 49);
                if (this.isAuthOk(responseBytes, eap, radiusSession, processor, req, nas, request, response, connectionSet, logRecordId)) {
                    log.debug("Password OK");
                    int length = this.authMessage.length + 4;
                    ByteBuffer bb = ByteBuffer.wrap(new byte[length]);
                    bb.put(OPCODE_SUCCESS);
                    byte by = this.msChapV2Id;
                    this.msChapV2Id = (byte)(by + 1);
                    bb.put(by);
                    bb.put((byte)(length >> 8));
                    bb.put((byte)(length & 0xFF));
                    bb.put(this.authMessage);
                    out = new EAPMessage(1, this.session.identifier, 26, bb);
                    this.state = State.accepting;
                    break;
                }
                log.debug("Password error");
                if (this.session.errorCode == 2) {
                    byte by = this.checkPasswordCount;
                    this.checkPasswordCount = (byte)(by + 1);
                    if (by < 3) {
                        secureRandom.nextBytes(this.challenge);
                        StringBuilder sb = new StringBuilder(80);
                        sb.append("E=691 R=1 C=");
                        sb.append(EAPMSChapV2Authentificator.bytesToString(this.challenge));
                        sb.append(" V=3 M=some error");
                        byte[] data = sb.toString().getBytes();
                        int length = data.length + 4;
                        ByteBuffer bb = ByteBuffer.wrap(new byte[length]);
                        bb.put(OPCODE_FAILURE);
                        byte by2 = this.msChapV2Id;
                        this.msChapV2Id = (byte)(by2 + 1);
                        bb.put(by2);
                        bb.put((byte)(length >> 8));
                        bb.put((byte)(length & 0xFF));
                        bb.put(data);
                        out = new EAPMessage(1, this.session.identifier, 26, bb);
                        this.state = State.rejecting;
                        break;
                    }
                }
                return this.session.reject();
            }
            case 2: {
                if (eap.getData().capacity() == 1 && eap.getData().get(0) == OPCODE_SUCCESS) {
                    return this.session.accept();
                }
                return this.session.reject();
            }
            default: {
                return this.session.reject();
            }
        }
        return out;
    }

    protected final boolean isAuthOk(byte[] challengeResponse, EAPMessage eap, RadiusSession<N, P> radiusSession, RadiusProcessor<?, N, P> processor, RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId) {
        this.challengeResponse = challengeResponse;
        if (this.session.errorCode == 0 || this.session.errorCode == 2) {
            int errorCode;
            this.session.acceptPacket = new RadiusPacket(0, 0);
            this.session.errorCode = errorCode = radiusSession.authentication(processor, req, nas, request, this.session.acceptPacket, connectionSet, logRecordId);
            return errorCode == 0;
        }
        return false;
    }

    @Override
    public boolean checkPassword(RadiusAttributeSet request, RadiusAttributeSet response, String openPassw, byte[] secret, byte[] authenticator) {
        try {
            byte[] peerChallenge = new byte[16];
            byte[] ntResponse = new byte[24];
            System.arraycopy(this.challengeResponse, 0, peerChallenge, 0, 16);
            System.arraycopy(this.challengeResponse, 24, ntResponse, 0, 24);
            this.authMessage = MSUtils.checkMSChapV2Password(this.challenge, peerChallenge, ntResponse, (String)this.session.userNameAttribute.getValue(), openPassw, null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        if (this.authMessage != null) {
            return true;
        }
        this.session.errorCode = 2;
        return false;
    }

    @Override
    public byte getAuthentificatorType() {
        return 26;
    }

    private static final String bytesToString(byte[] value) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                sb.append(Utils.HEX[(value[i] & 0xF0) >> 4]);
                sb.append(Utils.HEX[value[i] & 0xF]);
            }
        }
        return sb.toString();
    }

    @Override
    public byte[][] getMppeKeys() {
        return null;
    }

    @Override
    public EAPMessage start() {
        this.msChapV2Id = this.session.identifier;
        this.challenge = new byte[16];
        secureRandom.nextBytes(this.challenge);
        ByteBuffer data = ByteBuffer.wrap(new byte[30]);
        EAPMessage out = new EAPMessage(1, this.session.identifier, 26, data);
        data.put(OPCODE_CHALLENGE);
        data.put(this.msChapV2Id);
        data.put((byte)0);
        data.put((byte)30);
        data.put((byte)16);
        data.put(this.challenge);
        data.put((byte)66);
        data.put((byte)71);
        data.put((byte)66);
        data.put((byte)105);
        data.put((byte)108);
        data.put((byte)108);
        data.put((byte)105);
        data.put((byte)110);
        data.put((byte)103);
        return out;
    }

    static enum State {
        challenge,
        rejecting,
        accepting;

    }
}

