/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeCache;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TariffModuleTreeSetDao
extends BGLogger
implements AutoCloseable {
    private final Connection con;
    private PreparedStatement realtimeTariffPS = null;
    private PreparedStatement realtimePersonalTariffPS = null;
    private PreparedStatement dayTariffPS = null;
    private PreparedStatement dayPersonalTariffPS = null;

    public TariffModuleTreeSetDao(Connection con) {
        this.con = con;
    }

    public TariffModuleTreeSet getRealtimeTariffTreeSet(int contractId, java.util.Date time, String module, int moduleId, int emid, int eid) throws BGException {
        ArrayList<TariffModuleTreeSet.Entry> result = new ArrayList<TariffModuleTreeSet.Entry>(8);
        try {
            Date sqlTime = TimeUtils.convertDateToSqlDate((java.util.Date)time);
            GregorianCalendar utilCalendar = new GregorianCalendar();
            PreparedStatement ps = this.realtimePersonalTariffPS;
            if (ps == null) {
                ps = this.realtimePersonalTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2, 0 FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND (date2 IS NULL OR date2>=?) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, sqlTime);
            this.loadTreeEntries(module, moduleId, result, utilCalendar, ps);
            ps = this.realtimeTariffPS;
            if (ps == null) {
                ps = this.realtimeTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2, contract_tariff.id FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, sqlTime);
            this.loadTreeEntries(module, moduleId, result, utilCalendar, ps);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return new TariffModuleTreeSet(result);
    }

    public TariffModuleTreeSet getRealtimeTariffTreeSet(String module, int moduleId, List<ContractTariff> tariffList) throws BGException {
        ArrayList<TariffModuleTreeSet.Entry> result = new ArrayList<TariffModuleTreeSet.Entry>(8);
        if (!tariffList.isEmpty()) {
            String query = "SELECT id, tree_id FROM tariff_plan WHERE id IN (" + Utils.toString((Iterable)tariffList.stream().map(a -> a.getTariffPlanId()).collect(Collectors.toSet())) + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                HashMap<Integer, Integer> tariffTreeMap = new HashMap<Integer, Integer>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        tariffTreeMap.put(rs.getInt(1), rs.getInt(2));
                    }
                }
                TariffTreeCache tariffTreeCache = TariffTreeCache.getInstance();
                GregorianCalendar utilCalendar = new GregorianCalendar();
                for (ContractTariff tariff : tariffList) {
                    AtomicReference<TariffModuleTree> treeRef;
                    Integer treeId = (Integer)tariffTreeMap.get(tariff.getTariffPlanId());
                    if (treeId == null) {
                        this.getLogger().error("Not found treeId for tariff: " + tariff.getTariffPlanId());
                    }
                    if ((treeRef = tariffTreeCache.getModuleTree(this.con, treeId, moduleId, module)) == null) continue;
                    result.add(new TariffModuleTreeSet.Entry(treeRef, tariff.getId(), TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (java.util.Date)tariff.getPeriod().getDateFrom()), TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (java.util.Date)tariff.getPeriod().getDateTo())));
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return new TariffModuleTreeSet(result);
    }

    @Deprecated
    public TariffModuleTreeSet getTariffTreeSetForDay(int contractId, Calendar time, String module, int moduleId, int emid, int eid) throws BGException {
        LocalDate localDate = LocalDateTime.ofInstant(time.toInstant(), time.getTimeZone().toZoneId()).toLocalDate();
        return this.getTariffTreeSetForDay(contractId, localDate, module, moduleId, emid, eid);
    }

    public TariffModuleTreeSet getTariffTreeSetForDay(int contractId, LocalDate time, String module, int moduleId, int emid, int eid) throws BGException {
        ArrayList<TariffModuleTreeSet.Entry> result = new ArrayList<TariffModuleTreeSet.Entry>(8);
        try {
            Date day = TimeUtils.convertLocalDateToSqlDate((LocalDate)time);
            GregorianCalendar utilCalendar = new GregorianCalendar();
            PreparedStatement ps = this.dayPersonalTariffPS;
            if (ps == null) {
                ps = this.dayPersonalTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2, 0 FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?))  AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, day);
            ps.setDate(5, day);
            this.loadTreeEntries(module, moduleId, result, utilCalendar, ps);
            ps = this.dayTariffPS;
            if (ps == null) {
                ps = this.dayTariffPS = this.con.prepareStatement("SELECT tree_id, date1, date2, contract_tariff.id FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date1) OR date1='0000-00-00' OR date1<=? ) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) ORDER BY emid DESC, eid DESC, pos ASC");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, day);
            ps.setDate(5, day);
            this.loadTreeEntries(module, moduleId, result, utilCalendar, ps);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return new TariffModuleTreeSet(result);
    }

    private void loadTreeEntries(String module, int moduleId, List<TariffModuleTreeSet.Entry> result, Calendar utilCalendar, PreparedStatement ps) throws SQLException {
        TariffTreeCache tariffTreeBuilder = TariffTreeCache.getInstance();
        try (ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                AtomicReference<TariffModuleTree> treeRef = tariffTreeBuilder.getModuleTree(this.con, rs.getInt(1), moduleId, module);
                if (treeRef == null) continue;
                result.add(new TariffModuleTreeSet.Entry(treeRef, rs.getInt(4), TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (java.util.Date)rs.getDate(2)), TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (java.util.Date)rs.getDate(3))));
            }
        }
    }

    private void freeResources() throws BGException {
        try {
            if (this.check(this.realtimePersonalTariffPS)) {
                this.realtimePersonalTariffPS.close();
            }
            if (this.check(this.realtimeTariffPS)) {
                this.realtimeTariffPS.close();
            }
            if (this.check(this.dayPersonalTariffPS)) {
                this.dayPersonalTariffPS.close();
            }
            if (this.check(this.dayTariffPS)) {
                this.dayTariffPS.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private boolean check(PreparedStatement ps) throws SQLException {
        return ps != null && !ps.isClosed();
    }

    @Override
    public void close() throws BGException {
        this.freeResources();
    }
}

