/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;

public class CityDao
extends AbstractAddressDao<City>
implements Directory<City> {
    public CityDao(Connection con) {
        super(con, "address_city");
    }

    @Override
    protected City newBean() {
        return new City();
    }

    protected City getFromRS(ResultSet rs) throws SQLException, BGException {
        Country country = new Country();
        country.setId(rs.getInt("country.id"));
        country.setTitle(rs.getString("country.title"));
        City result = (City)super.getBaseFromRS(rs);
        result.setCountryId(rs.getInt("country_id"));
        result.setCountry(country);
        return result;
    }

    protected List<City> listImpl(Page page, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        String join = "LEFT JOIN address_country AS country ON " + this.tableName + ".country_id=country.id ";
        return super.listImpl(page, "*", join, filter, orderBy, params);
    }

    protected String getQueryById() {
        return "SELECT * FROM " + this.tableName + " LEFT JOIN address_country AS country ON " + this.tableName + ".country_id=country.id WHERE " + this.tableName + ".id=?";
    }

    @Override
    protected String getQuery() {
        return "SELECT " + this.tableName + ".*, country.* FROM " + this.tableName + " LEFT JOIN address_country AS country ON " + this.tableName + ".country_id=country.id  WHERE ";
    }

    protected void updateImpl(City city) throws BGException, SQLException {
        City old = city.getId() > 0 ? (City)this.get(city.getId()) : null;
        boolean update = old != null;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET country_id=?, title_prefix=?, title=?, title_suffix=?" + (update ? " WHERE " : ", ") + "id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, city.getCountryId());
            ps.setString(index++, city.getTitlePrefix());
            ps.setString(index++, city.getTitle());
            ps.setString(index++, city.getTitleSuffix());
            ps.setInt(index++, city.getId());
            ps.executeUpdate();
            if (!update) {
                city.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    @Override
    public List<City> list() throws BGException {
        try {
            return super.listImpl(new Page(), "country.*, " + this.tableName + ".*", "LEFT JOIN address_country AS country ON country.id=country_id", null, this.tableName + ".title", new Object[0]);
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    public List<City> list(int countryId) throws BGException {
        return super.list("country_id=?", "title", new Object[]{countryId});
    }

    public List<City> list(int countryId, String title) throws BGException {
        return super.list("(? OR country_id=?) AND (? OR " + this.tableName + ".title LIKE ?)", this.tableName + ".title", new Object[]{countryId <= 0, countryId, Utils.isBlankString((String)title), title + "%"});
    }

    @Override
    public City get(String title) throws BGException {
        return (City)super.get(this.tableName + ".title=?", title);
    }

    public City get(String title, int countryId) throws BGException {
        return (City)super.get(this.tableName + ".title=? AND " + this.tableName + ".country_id=?", title, countryId);
    }

    public void searchCityList(SearchResult<City> searchResult, int countryId, String cityMask) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " LEFT JOIN address_country AS country ON " + this.tableName + ".country_id=country.id  WHERE true" + (String)(countryId > 0 ? " AND " + this.tableName + ".country_id=?" : "") + (String)(cityMask != null && !cityMask.isEmpty() ? " AND " + this.tableName + ".title LIKE ?" : "") + " ORDER BY " + this.tableName + ".title" + Page.toSqlLimit((Page)page);
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (countryId > 0) {
                    ps.setInt(index++, countryId);
                }
                if (cityMask != null && !cityMask.isEmpty()) {
                    ps.setString(index++, cityMask);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows(this.con));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public int countryCityCount(int countryId) throws BGException {
        return this.getEntityCount(countryId, "country_id");
    }
}

